package com.elitescloud.cloudt.system.cacheable.impl;

import com.elitescloud.boot.common.annotation.CloudtCache;
import com.elitescloud.boot.common.annotation.CloudtCacheMethod;
import com.elitescloud.boot.core.support.cache.common.AbstractCacheableService;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.system.cacheable.SysCacheTaxRateRpcService;
import com.elitescloud.cloudt.system.constant.SysCacheType;
import com.elitescloud.cloudt.system.dto.req.SysTaxRateQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.SysTaxRateRespDTO;
import com.elitescloud.cloudt.system.provider.extend.SysTaxRateRpcService;
import com.mysema.commons.lang.Assert;
import org.springframework.stereotype.Component;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/6/27
 */
@Component
@CloudtCache(type = SysCacheType.extend, name = "税率")
public class SysCacheTaxRateRpcServiceImpl extends AbstractCacheableService implements SysCacheTaxRateRpcService {

    @CloudtCacheMethod(name = "根据编码获取税率信息")
    @Override
    public SysTaxRateRespDTO getByTxtNo(String no) {
        Assert.hasText(no, "税率编码为空");

        return getService(SysTaxRateRpcService.class).getByTaxRateNo(no).computeData();
    }

    @CloudtCacheMethod(name = "获取税率列表")
    @Override
    public List<SysTaxRateRespDTO> getAll() {
        return getService(SysTaxRateRpcService.class).queryList(new SysTaxRateQueryDTO()).computeData();
    }

    @Override
    public @NotBlank String appCode() {
        return Application.NAME;
    }

    @Override
    public @NotBlank String code() {
        return "taxRate";
    }
}
