package com.elitescloud.cloudt.system.cacheable.impl;

import com.elitescloud.boot.common.annotation.CloudtCache;
import com.elitescloud.boot.common.annotation.CloudtCacheMethod;
import com.elitescloud.boot.core.support.cache.common.AbstractCacheableService;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.system.cacheable.SysCacheTenantRpcService;
import com.elitescloud.cloudt.system.constant.SysCacheType;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.system.provider.TenantRpcProvider;
import com.mysema.commons.lang.Assert;
import org.springframework.stereotype.Component;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/6/27
 */
@Component
@CloudtCache(type = SysCacheType.basic, name = "租户")
public class SysCacheTenantRpcServiceImpl extends AbstractCacheableService implements SysCacheTenantRpcService {

    @CloudtCacheMethod(name = "根据编码获取租户信息")
    @Override
    public SysTenantDTO getByCode(String code) {
        Assert.hasText(code, "租户编码为空");
        return getRpcService().getByCode(code).computeData();
    }

    @CloudtCacheMethod(name = "获取租户列表")
    @Override
    public List<SysTenantDTO> getAll() {
        return getRpcService().allTenants().computeData();
    }

    @Override
    public @NotBlank String appCode() {
        return Application.NAME;
    }

    @Override
    public @NotBlank String code() {
        return "tenant";
    }

    @Override
    public boolean supportTenant() {
        return false;
    }

    private TenantRpcProvider getRpcService() {
        return getService(TenantRpcProvider.class);
    }
}
