package com.elitescloud.cloudt.system.dto;

import lombok.Data;
import org.springframework.util.StringUtils;

import java.io.Serializable;

/**
 * 员工基本信息.
 *
 * @author Kaiser（wang shao）
 * 2022/10/9
 */
@Data
public class SysEmployeeBasicDTO implements Serializable {
    private static final long serialVersionUID = 9212693956847559553L;

    /**
     * 员工ID
     */
    private Long id;

    /**
     * 账号ID
     */
    private Long userId;

    /**
     * 账号
     */
    private String username;

    /**
     * 根组织ID
     */
    private Long rootOrgId;

    /**
     * 姓名-姓氏
     */
    private String lastName;

    /**
     * 姓名-名字
     */
    private String firstName;

    /**
     * 性别
     * {@link com.elitescloud.cloudt.common.constant.Gender}
     */
    private String gender;

    /**
     * 员工编号
     */
    private String code;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 办公邮箱
     */
    private String emailWork;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 办公电话
     */
    private String phone;

    /**
     * 是否在职
     */
    private Boolean served;

    /**
     * 员工类型
     * <p>
     * {@link com.elitescloud.cloudt.system.constant.EmployeeType}
     */
    private String type;

    /**
     * 岗位
     */
    private String duty;

    /**
     * 照片
     */
    private String photo;

    /**
     * 是否启用
     */
    private Boolean enabled;

    /**
     * 顺序
     */
    private Integer sortNo;

    /**
     * 组织ID
     */
    private transient Long orgId;

    /**
     * 获取全名
     *
     * @return 全名
     */
    public String getFullName() {
        if (!StringUtils.hasText(lastName)) {
            return firstName;
        }

        return lastName + (firstName == null ? "" : firstName);
    }
}
