package com.elitescloud.cloudt.system.dto.req;

import lombok.Data;

import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.List;

/**
 * 根据名称查询参数.
 *
 * @author Kaiser（wang shao）
 * @date 2023/11/7
 */
@Data
public class SysAreaNamesQueryDTO implements Serializable {
    private static final long serialVersionUID = 7110244571646121793L;

    /**
     * 编码或名称
     */
    @NotEmpty(message = "行政区域的编码或名称为空")
    private List<List<String>> codeOrNames;

    /**
     * 是否模糊查询
     */
    private Boolean fuzzy;
}
