package com.elitescloud.cloudt.system.dto.req;

import lombok.Data;

import java.io.Serializable;
import java.util.Set;

/**
 * 行政区域查询参数.
 *
 * @author Kaiser（wang shao）
 * @date 3/3/2023
 */
@Data
public class SysAreaQueryDTO implements Serializable {
    private static final long serialVersionUID = 4329623915727575439L;

    /**
     * 行政区域编码
     */
    private String areaCode;

    /**
     * 行政区域编码列表
     */
    private Set<String> areaCodes;

    /**
     * 行政区域名称
     * <p>
     * 精确查询
     */
    private String areaName;

    /**
     * 行政区域名称列表
     * <p>
     * 精确查询
     */
    private Set<String> areaNames;

    /**
     * 模糊查询名称
     * <p>
     * 右模糊
     */
    private String areaNameRightLike;

    /**
     * 编码或名称
     */
    private String codeOrName;

    /**
     * 编码或名称
     */
    private Set<String> codeOrNames;

    /**
     * 上级地区编码
     */
    private String parentAreaCode;

    /**
     * 区域类型
     * <p>UDC[cloudt-system:areaType] {@link com.elitescloud.cloudt.constant.AreaType}</p>
     */
    private String areaType;

    /**
     * 启用状态
     */
    private Boolean enabled;

    /**
     * 拼音
     */
    private String pinyin;
}
