package com.elitescloud.cloudt.system.dto.resp;

import lombok.Data;

import java.io.Serializable;

/**
 * 组织分页查询结果.
 *
 * @author Kaiser（wang shao）
 * @date 2023/6/13
 */
@Data
public class SysOrgPageRespDTO implements Serializable {
    private static final long serialVersionUID = -8084941676676917195L;

    /**
     * 组织ID
     */
    private Long id;

    /**
     * 组织编码
     */
    private String code;

    /**
     * 外部组织编码
     */
    private String outerCode;

    /**
     * 组织名称
     */
    private String name;

    /**
     * 上级组织编码
     */
    private String parentCode;

    /**
     * 简称
     */
    private String shortName;

    /**
     * 类型
     */
    private String type;

    /**
     * 类型
     */
    private String typeName;

    /**
     * 是否启用
     */
    private Boolean enabled;

    /**
     * 所属公司（系统域的公司）
     */
    private Long ouId;

    /**
     * 符合条件的上级组织ID
     *
     * 结合查询条件中的字段 {@link com.elitescloud.cloudt.system.dto.req.SysOrgPageQueryDTO#withParentType} 一起使用
     */
    private Long withParentId;

    /**
     * 符合条件的上级组织编码
     */
    private String withParentCode;

    /**
     * 符合条件的上级组织名称
     */
    private String withParentName;

    public String getPrettyName() {
        if (shortName == null || shortName.trim().length() == 0) {
            return name;
        }
        return shortName;
    }
}
