package com.elitescloud.cloudt.system.dto.resp;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serial;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Map;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/10/9 周四
 */
@Getter
@Setter
public class SysQuartzJobRespDTO implements Serializable {
    @Serial
    private static final long serialVersionUID = 5219045871600647005L;

    @ApiModelProperty(value = "任务编码")
    private String jobCode;

    @ApiModelProperty(value = "任务组编码")
    private String groupCode;

    @ApiModelProperty(value = "任务名称")
    private String jobName;

    @ApiModelProperty(value = "任务是否启用")
    private Boolean enabled;

    @ApiModelProperty(value = "任务描述")
    private String description;

    @ApiModelProperty(value = "任务数据")
    private Map<String, String> jobData;

    @ApiModelProperty(value = "任务类")
    private String jobClass;

    @ApiModelProperty(value = "触发器类型")
    private String triggerType;
    @ApiModelProperty(value = "触发器参数")
    private String triggerJson;

    @ApiModelProperty(value = "任务开始时间")
    private LocalDateTime starDate;

    @ApiModelProperty(value = "任务结束时间")
    private LocalDateTime endDate;
}
