package com.elitescloud.cloudt.system.provider;

import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.ApiResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * ID服务.
 *
 * @author Kaiser（wang shao）
 * @date 2025/6/13 周五
 */
@FeignClient(name = Application.NAME, path = SysIdRpcService.URI)
@Validated
public interface SysIdRpcService {
    String URI = Application.URI_PREFIX + "/id";

    /**
     * 生成ID.
     *
     * @return {@link ApiResult}<{@link Long}>
     */
    @GetMapping(value = "/generate")
    ApiResult<Long> generateId();

    /**
     * 生成多个ID.
     *
     * @param num 数量
     * @return {@link ApiResult}<{@link List}<{@link Long}>>
     */
    @GetMapping(value = "/generate/batch")
    ApiResult<List<Long>> generateIds(@RequestParam(name = "num", required = false) Integer num);
}
