package com.elitescloud.cloudt.system.provider;

import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.provider.dto.save.SysNoticeSaveDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;
import java.util.Set;

/**
 * 公告服务.
 *
 * @author Kaiser（wang shao）
 * @date 2024/8/29
 */
@FeignClient(name = Application.NAME, path = SysNoticeRpcService.URI)
@Validated
public interface SysNoticeRpcService {

    String URI = Application.URI_PREFIX + "/notice";

    /**
     * 公告发布
     *
     * @param saveDTO 公告信息
     * @return 公告ID
     */
    @PostMapping(value = "/publish")
    ApiResult<Long> publish(@RequestBody SysNoticeSaveDTO saveDTO);

    /**
     * 公告发布
     *
     * @param saveDTOList 公告信息
     * @return 公告ID
     */
    @PostMapping(value = "/publishBatch")
    ApiResult<List<Long>> publish(@RequestBody List<SysNoticeSaveDTO> saveDTOList);

    /**
     * 撤回公告
     *
     * @param id 公告ID
     * @return 公告ID
     */
    @GetMapping(value = "/revoke")
    ApiResult<Long> revoke(@NotNull(message = "公告ID为空") @RequestParam(name = "id") Long id);

    /**
     * 批量撤回公告
     *
     * @param ids 公告ID
     * @return 公告ID
     */
    @PostMapping(value = "/revokeBatch")
    ApiResult<Set<Long>> revokeBatch(@NotEmpty(message = "公告ID为空") @RequestBody Set<Long> ids);
}
