package com.elitescloud.cloudt.system.provider;

import com.elitescloud.boot.swagger.feignapi.DocumentedFeignApi;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.req.UnifyQueryQueryDTO;
import com.elitescloud.cloudt.system.dto.req.UnifySqlQueryQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.UnifyQueryRespDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 业务数据统一查询服务接口.
 *
 * @author Kaiser（wang shao）
 * @date 2024/6/6
 */
@FeignClient(name = Application.NAME, path = SysUnifyQueryRpcService.URI)
@Validated
@DocumentedFeignApi( description = "业务数据统一SQL查询服务")
public interface SysUnifyQueryRpcService {
    String URI = Application.URI_PREFIX + "/unifyQuery";

    /**
     * 查询数据
     *
     * @param paramDTO 查询参数
     * @return 查询结果
     */
    @PostMapping(value = "/query")
    @DocumentedFeignApi( description = "查询数据")
    ApiResult<UnifyQueryRespDTO> query(@RequestBody UnifyQueryQueryDTO paramDTO);

    /**
     * 根据SQL查询
     *
     * @param paramDTO 查询参数
     * @return 查询结果
     */
    @PostMapping(value = "/queryBySql")
    @DocumentedFeignApi( description = "根据SQL查询")
    ApiResult<UnifyQueryRespDTO> queryBySql(@RequestBody UnifySqlQueryQueryDTO paramDTO);
}
