package com.elitescloud.cloudt.system.provider.extend;

import com.elitescloud.boot.swagger.feignapi.DocumentedFeignApi;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.req.SysTaxRateQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.SysTaxRateRespDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * 税率服务接口.
 *
 * @author Kaiser（wang shao）
 * @date 2/7/2023
 */
@FeignClient(name = Application.NAME, path = SysTaxRateRpcService.URI)
@Validated
@DocumentedFeignApi( description = "税率服务")
public interface SysTaxRateRpcService {
    String URI = Application.URI_PREFIX + "/taxRate";

    /**
     * 根据税率编码获取税率信息
     *
     * @param taxRateNo 税率编码
     * @return 税率信息
     */
    @GetMapping(value = "/getByTaxRateNo")
    ApiResult<SysTaxRateRespDTO> getByTaxRateNo(@RequestParam("taxRateNo") @NotBlank(message = "税率编码为空") String taxRateNo);

    /**
     * 税率查询
     *
     * @param queryDTO 查询参数
     * @return 税率列表
     */
    @PostMapping(value = "/queryList")
    ApiResult<List<SysTaxRateRespDTO>> queryList(@RequestBody SysTaxRateQueryDTO queryDTO);
}
