package com.elitescloud.cloudt.system.service;

import com.elitescloud.boot.swagger.feignapi.DocumentedFeignApi;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiRowColumnRuleDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * @author : chen
 *  角色应用api的数据权限远程调用接口
 * 2022-11-24 14:23
 */
@FeignClient(name = Application.NAME, path = RoleAppApiDataPermissionRpcService.URI)
@Validated
@DocumentedFeignApi( description = "角色的数据权限服务")
public interface RoleAppApiDataPermissionRpcService {
    String URI = Application.URI_PREFIX + "/role/app/api/data/permission";

    /**
     * 获取角色的数据权限信息
     * @return 角色ID的数据集合
     */
    @DocumentedFeignApi( description = "获取角色的数据权限信息")
    @PostMapping(value = "/getRoleAppApiDataRulePermission")
    ApiResult<SysDprRoleApiRowColumnRuleDTO> getRoleAppApiDataRulePermission();

    /**
     * 获取角色的数据权限信息
     * @return 角色ID的数据集合
     */
    @GetMapping(value = "/getDataRulePermission")
    @DocumentedFeignApi( description = "获取角色的数据权限信息-与getRoleAppApiDataRulePermission相同")
    ApiResult<SysDprRoleApiRowColumnRuleDTO> getDataRulePermission();
}
