package com.elitescloud.cloudt.system.cacheable;

import com.elitescloud.boot.core.support.common.CacheableService;
import com.elitescloud.cloudt.system.dto.resp.SysTaxRateRespDTO;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/6/27
 */
public interface SysCacheTaxRateRpcService extends CacheableService {

    /**
     * 根据税率编码获取税率
     *
     * @param no 税率编码
     * @return 税率信息
     */
    SysTaxRateRespDTO getByTxtNo(@NotBlank String no);

    /**
     * 获取税率列表
     *
     * @return 税率列表
     */
    List<SysTaxRateRespDTO> getAll();
}
