package com.elitescloud.cloudt.system.constant;

import cn.hutool.core.text.CharSequenceUtil;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 数据权限类型.
 *
 * @author Kaiser（wang shao）
 * @date 2024/3/21
 */
public enum DataPermissionType {

    /**
     * 业务对象公共资源
     */
    BUSINESS_RESOURCE_RULE("业务对象资源"),
    /**
     * 业务对象的权限规则
     */
    BUSINESS_OBJECT_RULE("业务对象"),
    /**
     * 业务对象操作的权限规则
     */
    BUSINESS_OPERATION_RULE("业务对象的操作"),
    /**
     * 菜单操作的权限规则
     */
    MENU_OPERATION_RULE("菜单的业务操作"),
    ;

    private final String description;

    private DataPermissionType(String description) {
        this.description = description;
    }

    public String getDescription() {
        return description;
    }

    /**
     * 转换对象
     *
     * @param value
     * @return
     */
    public static DataPermissionType fromValue(String value) {
        if (CharSequenceUtil.isBlank(value)) {
            return null;
        }

        for (DataPermissionType d : DataPermissionType.values()) {
            if (d.name().equals(value)) {
                return d;
            }
        }
        return null;
    }

    public static String getDescription(String value) {
        DataPermissionType d = fromValue(value);
        return d == null ? null : d.getDescription();
    }
}
