package com.elitescloud.cloudt.system.constant;

import com.elitescloud.boot.common.BaseUdc;
import com.elitescloud.cloudt.Application;

import javax.validation.constraints.NotBlank;

/**
 * 终端类型.
 *
 * @author Kaiser（wang shao）
 * @date 2024/12/1
 */
public class SysTerminalType extends BaseUdc<SysTerminalType> {
    private static final long serialVersionUID = 2969863397404666120L;

    /**
     * web端
     */
    public static final SysTerminalType WEB = new SysTerminalType("web", "WEB");
    /**
     * app端
     */
    public static final SysTerminalType APP = new SysTerminalType("app", "APP");

    public SysTerminalType() {
    }

    public SysTerminalType(String value) {
        super(value);
    }

    public SysTerminalType(String value, String description) {
        super(value, description);
    }

    @Override
    public @NotBlank String getAppCode() {
        return Application.NAME;
    }

    @Override
    public @NotBlank String getUdcCode() {
        return "terminalType";
    }
}
