package com.elitescloud.cloudt.system.dto;

import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 * 数据权限规则
 *
 * @author : chen.niu
 * @date 2023/1/31 14:45
 */
@Getter
@Setter
public class SysDprRoleApiDataRuleListQueryDTO extends BaseDataSecurityRuleDTO {
    private static final long serialVersionUID = 7141376063059273586L;

    /**
     * 是否是规则组
     */
    private Boolean ruleGroup;

    /**
     * 组内规则列表
     */
    private List<SysDprRoleApiDataRuleListQueryDTO> groupRules;

    /**
     * 分组
     */
    private String ruleGroupCode;

    /**
     * 上级规则组编码
     */
    private String ruleGroupCodeParent;

    /**
     * 数据权限规则ID
     */
    private Long dprRuleId;

    /**
     * 规则顺序
     */
    private Integer order;

    /**
     * 数据集类型
     */
    private String dataSet;

    /**
     * 规则关系
     * <p>
     * 取值：{@link com.elitescloud.boot.datasecurity.dpr.content.DprRuleRelationEnum}
     */
    private String dprRuleRelation;

    /**
     * 规则名称
     */
    private String dprRuleName;

    /**
     * 规则字段
     */
    private String dprRuleField;

    /**
     * 实体类名称
     */
    private String entityClassName;

    /**
     * 是否为子表
     */
    private Boolean subTable;

    /**
     * 与主表关联的字段
     */
    private String relatedMasField;

    /**
     * 关联的主表中的字段
     */
    private String masField;

    /**
     * 是否引用资源配置
     */
    private Boolean refResource;

    /**
     * 引用的业务对象编码
     */
    private String refBusinessObject;

    /**
     * 引用的业务对象字段
     */
    private String refField;

    /**
     * 规则字段类型
     */
    private String dprRuleFieldType;

    /**
     * 规则条件类型
     * <p>
     * 取值：{@link com.elitescloud.boot.datasecurity.dpr.content.DprRuleConditionEnum}
     */
    private String dprRuleCondition;

    /**
     * 规则值类型
     * <p>
     * 取值，{@link com.elitescloud.boot.datasecurity.dpr.content.DprRuleValueTypeEnum}
     */
    private String dprRuleValueType;

    /**
     * 规则值
     */
    private String dprRuleValue;

    /**
     * 值名称
     */
    private String dprRuleValueName;

    /**
     * 特用字段1
     */
    private String bs1;

    /**
     * 特用字段2
     */
    private String bs2;

    /**
     * 特用字段3
     */
    private String bs3;

    /**
     * 是否是数据范围
     *
     * @deprecated 新版本数据权限中取消了该字段
     */
    @Deprecated(since = "3.2.5")
    private Boolean dataRange;

    /**
     * 系统内置时的规则值
     *
     * @deprecated 统一使用 {@link #dprRuleValue}
     */
    @Deprecated(since = "3.3.0", forRemoval = true)
    private String dprSysInternally;

    /**
     * 规则顺序
     * <p>
     * 改用 {@link #order}
     */
    @Deprecated(since = "3.3.0")
    private Double ruleOrder;
}
