package com.elitescloud.cloudt.system.dto;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 账号类型.
 *
 * @author Kaiser（wang shao）
 * @date 2023/12/26
 */
@Data
public class SysUserTypeDTO implements Serializable {
    private static final long serialVersionUID = -4469522420194421081L;

    /**
     * 账号类型
     * <p>
     * {@link com.elitescloud.cloudt.system.constant.UserType}
     */
    @NotBlank(message = "账号类型不能为空")
    private String userType;

    /**
     * 身份标识ID
     */
    private String identityId;

    public SysUserTypeDTO() {
    }

    public SysUserTypeDTO(String userType) {
        this.userType = userType;
    }

    public SysUserTypeDTO(String userType, String identityId) {
        this.userType = userType;
        this.identityId = identityId;
    }
}
