package com.elitescloud.cloudt.system.quartz.model.bo;

import com.elitescloud.cloudt.system.quartz.common.SysQuartzJobType;
import com.elitescloud.cloudt.system.quartz.model.bo.schedule.SysQuartzTrigger;
import lombok.Getter;
import lombok.Setter;
import org.quartz.Job;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serial;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/9/20 周六
 */
@Getter
@Setter
public class SysQuartzJobSaveParam implements Serializable {
    @Serial
    private static final long serialVersionUID = -6197690485223806558L;

    /**
     * 任务编码
     * <p>
     * 需保证唯一
     */
    @NotBlank
    private String jobCode;

    /**
     * 任务名称
     */
    private String jobName;

    /**
     * 任务类型
     */
    @NotNull
    private SysQuartzJobType jobType;

    /**
     * 任务描述
     */
    private String description;

    /**
     * 任务类
     */
    @NotNull
    private Class<? extends Job> jobClass;

    /**
     * 任务数据
     */
    private Map<String, String> jobData;

    /**
     * 触发器
     */
    @NotNull
    private SysQuartzTrigger trigger;

    /**
     * 任务启动时间
     * <p>
     * 默认为当前时间
     */
    private Date startTime;

    /**
     * 任务结束时间
     */
    private Date endTime;

    /**
     * 租户ID
     */
    private Long tenantId;
}
