package com.elitescloud.cloudt.system.quartz.model.bo.schedule;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.system.quartz.common.SysQuartzTriggerType;
import org.quartz.Trigger;
import org.quartz.impl.triggers.CronTriggerImpl;

import java.io.Serial;
import java.text.ParseException;

/**
 * Cron触发器.
 *
 * @author Kaiser（wang shao）
 * @date 2025/10/11 周六
 */
public class CronSysQuartzTrigger implements SysQuartzTrigger {
    @Serial
    private static final long serialVersionUID = -4504065887356202893L;

    /**
     * Cron表达式
     */
    private String cron;

    public CronSysQuartzTrigger() {
    }

    public CronSysQuartzTrigger(String cron) {
        this.cron = cron;
    }

    @Override
    public SysQuartzTriggerType triggerType() {
        return SysQuartzTriggerType.CRON;
    }

    @Override
    public void validate() {
        Assert.notBlank(cron, "Cron表达式不能为空");
    }

    @Override
    public Trigger buildTrigger() {
        CronTriggerImpl trigger = new CronTriggerImpl();
        try {
            trigger.setCronExpression(cron);
        } catch (ParseException e) {
            throw new IllegalArgumentException("构建触发器失败：" + cron, e);
        }
        return trigger;
    }

    public String getCron() {
        return cron;
    }

    public void setCron(String cron) {
        this.cron = cron;
    }
}
