package com.elitescloud.cloudt.system.quartz.model.bo.schedule;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.system.quartz.common.SysQuartzTriggerType;
import org.quartz.CalendarIntervalScheduleBuilder;
import org.quartz.DateBuilder;
import org.quartz.ScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.impl.triggers.CalendarIntervalTriggerImpl;

import java.io.Serial;

/**
 * 基于日历的时间间隔.
 *
 * @author Kaiser（wang shao）
 * @date 2025/10/11 周六
 */
public class IntervalCalendarSysQuartzTrigger implements SysQuartzTrigger {
    @Serial
    private static final long serialVersionUID = -1991548270265263447L;

    /**
     * 间隔时间
     */
    private Integer interval;

    /**
     * 间隔时间单位
     */
    private IntervalUnit intervalUnit;

    public IntervalCalendarSysQuartzTrigger() {
    }

    public IntervalCalendarSysQuartzTrigger(Integer interval, IntervalUnit intervalUnit) {
        this.interval = interval;
        this.intervalUnit = intervalUnit;
    }

    @Override
    public SysQuartzTriggerType triggerType() {
        return SysQuartzTriggerType.INTERVAL_CALENDAR;
    }

    @Override
    public void validate() {
        Assert.notNull(interval, "间隔时间不能为空");
        Assert.isTrue(interval > 0, "间隔时间不能小于0");
        Assert.notNull(intervalUnit, "间隔时间单位不能为空");
    }

    @Override
    public Trigger buildTrigger() {
        CalendarIntervalTriggerImpl trigger = new CalendarIntervalTriggerImpl();

        DateBuilder.IntervalUnit unit = switch (intervalUnit) {
            case MILLISECOND -> DateBuilder.IntervalUnit.MILLISECOND;
            case SECOND -> DateBuilder.IntervalUnit.SECOND;
            case MINUTE -> DateBuilder.IntervalUnit.MINUTE;
            case HOUR -> DateBuilder.IntervalUnit.HOUR;
            case DAY -> DateBuilder.IntervalUnit.DAY;
            case WEEK -> DateBuilder.IntervalUnit.WEEK;
            case MONTH -> DateBuilder.IntervalUnit.MONTH;
            case YEAR -> DateBuilder.IntervalUnit.YEAR;
        };

        trigger.setRepeatInterval(interval);
        trigger.setRepeatIntervalUnit(unit);
        return trigger;
    }

    public Integer getInterval() {
        return interval;
    }

    public void setInterval(Integer interval) {
        this.interval = interval;
    }

    public IntervalUnit getIntervalUnit() {
        return intervalUnit;
    }

    public void setIntervalUnit(IntervalUnit intervalUnit) {
        this.intervalUnit = intervalUnit;
    }

    public enum IntervalUnit { MILLISECOND, SECOND, MINUTE, HOUR, DAY, WEEK, MONTH, YEAR }
}
