package com.elitescloud.cloudt.system.quartz.model.bo.schedule;

import com.elitescloud.cloudt.system.quartz.common.SysQuartzTriggerType;
import org.quartz.ScheduleBuilder;
import org.quartz.Trigger;

import java.io.Serializable;

/**
 * 触发器类型.
 *
 * @author Kaiser（wang shao）
 * @date 2025/10/11 周六
 */
public interface SysQuartzTrigger extends Serializable {

    /**
     * 获取触发器类型.
     *
     * @return {@link SysQuartzTriggerType}
     */
    SysQuartzTriggerType triggerType();

    /**
     * 校验参数.
     */
    void validate();

    /**
     * 构建触发器.
     *
     * @return {@link Trigger}
     */
    Trigger buildTrigger();

    /**
     * 构建调度.
     *
     * @return {@link ScheduleBuilder}
     */
    default ScheduleBuilder<?> buildScheduleBuilder() {
        return buildTrigger().getScheduleBuilder();
    }
}
