package com.elitescloud.cloudt.system.quartz.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.system.quartz.common.SysQuartzTriggerType;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;
import java.io.Serial;
import java.time.LocalDateTime;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/9/21 周日
 */
@Entity
@Table(name = "sys_quartz_job", indexes = {
        @Index(name = "idx_sys_quartz_job_code", columnList = "jobCode", unique = true),
        @Index(name = "idx_sys_quartz_job_group", columnList = "groupCode"),
})
@Comment("调度任务信息")
@Getter
@Setter
public class SysQuartzJobDO extends BaseModel {
    @Serial
    private static final long serialVersionUID = 2503580545609647211L;

    @Comment(value = "任务编码")
    @Column(nullable = false, length = 32)
    private String jobCode;

    @Comment(value = "任务组编码")
    @Column(nullable = false, length = 32)
    private String groupCode;

    @Comment(value = "任务名称")
    @Column(length = 64)
    private String jobName;

    @Comment(value = "任务是否启用", defaultValue = "0")
    @Column()
    private Boolean enabled;

    @Comment(value = "系统租户ID")
    @Column()
    private Long sysTenantId;

    @Comment(value = "任务描述")
    @Column(length = 128)
    private String description;

    @Comment(value = "任务类")
    @Column(nullable = false, length = 256)
    private String jobClass;

    @Comment(value = "任务数据")
    @Column()
    @Lob
    private String jobDataJson;

    /**
     * @see SysQuartzTriggerType
     */
    @Comment(value = "任务触发器类型")
    @Column(length = 64)
    private String triggerType;

    @Comment(value = "任务触发器")
    @Column()
    @Lob
    private String triggerJson;

    @Comment(value = "任务开始时间")
    @Column()
    private LocalDateTime starDate;

    @Comment(value = "任务结束时间")
    @Column()
    private LocalDateTime endDate;
}
