/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.quartz.model.bo.schedule;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.util.cron.constant.CronWeek;
import com.elitescloud.cloudt.system.quartz.common.SysQuartzTriggerType;
import com.elitescloud.cloudt.system.quartz.model.bo.schedule.SysQuartzTrigger;
import java.time.LocalTime;
import java.util.Set;
import java.util.stream.Collectors;
import org.quartz.DailyTimeIntervalScheduleBuilder;
import org.quartz.DateBuilder;
import org.quartz.ScheduleBuilder;
import org.quartz.TimeOfDay;
import org.quartz.Trigger;
import org.quartz.impl.triggers.DailyTimeIntervalTriggerImpl;

public class DailyTimeSysQuartzTrigger
implements SysQuartzTrigger {
    private static final long serialVersionUID = 4096913218789438545L;
    private Integer interval;
    private IntervalUnit intervalUnit;
    private Set<CronWeek> dayOfWeeks;
    private LocalTime startTime;
    private LocalTime endTime;
    private Integer repeatCountOfDay;
    private Integer repeatCount;

    @Override
    public SysQuartzTriggerType triggerType() {
        return SysQuartzTriggerType.INTERVAL_DAILY_TIME;
    }

    @Override
    public void validate() {
        Assert.notNull((Object)this.interval, (String)"\u95f4\u9694\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.isTrue((this.interval > 0 ? 1 : 0) != 0, (String)"\u95f4\u9694\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e0", (Object[])new Object[0]);
        Assert.notNull((Object)((Object)this.intervalUnit), (String)"\u95f4\u9694\u65f6\u95f4\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.isTrue((this.repeatCountOfDay == null || this.repeatCountOfDay > 0 ? 1 : 0) != 0, (String)"\u91cd\u590d\u6b21\u6570\u4e0d\u80fd\u4e3a0", (Object[])new Object[0]);
        Assert.isTrue((this.repeatCount == null || this.repeatCount != 0 ? 1 : 0) != 0, (String)"\u91cd\u590d\u6b21\u6570\u4e0d\u80fd\u4e3a0", (Object[])new Object[0]);
    }

    @Override
    public Trigger buildTrigger() {
        DailyTimeIntervalTriggerImpl trigger = new DailyTimeIntervalTriggerImpl();
        DateBuilder.IntervalUnit unit = switch (this.intervalUnit) {
            default -> throw new IncompatibleClassChangeError();
            case IntervalUnit.SECOND -> DateBuilder.IntervalUnit.SECOND;
            case IntervalUnit.MINUTE -> DateBuilder.IntervalUnit.MINUTE;
            case IntervalUnit.HOUR -> DateBuilder.IntervalUnit.HOUR;
        };
        trigger.setRepeatInterval(this.interval.intValue());
        trigger.setRepeatIntervalUnit(unit);
        if (CollUtil.isNotEmpty(this.dayOfWeeks)) {
            trigger.setDaysOfWeek(this.dayOfWeeks.stream().map(CronWeek::getValue).collect(Collectors.toSet()));
        }
        if (this.startTime != null) {
            trigger.setStartTimeOfDay(TimeOfDay.hourMinuteAndSecondOfDay((int)this.startTime.getHour(), (int)this.startTime.getMinute(), (int)this.startTime.getSecond()));
        }
        if (this.endTime != null) {
            trigger.setEndTimeOfDay(TimeOfDay.hourMinuteAndSecondOfDay((int)this.endTime.getHour(), (int)this.endTime.getMinute(), (int)this.endTime.getSecond()));
        }
        if (this.repeatCount != null) {
            trigger.setRepeatCount(this.repeatCount.intValue());
        }
        return trigger;
    }

    @Override
    public ScheduleBuilder<?> buildScheduleBuilder() {
        DailyTimeIntervalScheduleBuilder scheduleBuilder = (DailyTimeIntervalScheduleBuilder)this.buildTrigger().getScheduleBuilder();
        if (this.repeatCountOfDay != null) {
            scheduleBuilder.endingDailyAfterCount(this.repeatCountOfDay.intValue());
        }
        return scheduleBuilder;
    }

    public Integer getInterval() {
        return this.interval;
    }

    public void setInterval(Integer interval) {
        this.interval = interval;
    }

    public IntervalUnit getIntervalUnit() {
        return this.intervalUnit;
    }

    public void setIntervalUnit(IntervalUnit intervalUnit) {
        this.intervalUnit = intervalUnit;
    }

    public Set<CronWeek> getDayOfWeeks() {
        return this.dayOfWeeks;
    }

    public void setDayOfWeeks(Set<CronWeek> dayOfWeeks) {
        this.dayOfWeeks = dayOfWeeks;
    }

    public LocalTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(LocalTime startTime) {
        this.startTime = startTime;
    }

    public LocalTime getEndTime() {
        return this.endTime;
    }

    public void setEndTime(LocalTime endTime) {
        this.endTime = endTime;
    }

    public Integer getRepeatCountOfDay() {
        return this.repeatCountOfDay;
    }

    public void setRepeatCountOfDay(Integer repeatCountOfDay) {
        this.repeatCountOfDay = repeatCountOfDay;
    }

    public Integer getRepeatCount() {
        return this.repeatCount;
    }

    public void setRepeatCount(Integer repeatCount) {
        this.repeatCount = repeatCount;
    }

    public static enum IntervalUnit {
        SECOND,
        MINUTE,
        HOUR;

    }
}

