/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.quartz.model.bo.schedule;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.system.quartz.common.SysQuartzTriggerType;
import com.elitescloud.cloudt.system.quartz.model.bo.schedule.SysQuartzTrigger;
import java.time.Duration;
import org.quartz.Trigger;
import org.quartz.impl.triggers.SimpleTriggerImpl;

public class IntervalSimpleSysQuartzTrigger
implements SysQuartzTrigger {
    private static final long serialVersionUID = 8444748402557028231L;
    private Duration duration;
    private Integer repeatCount;

    public IntervalSimpleSysQuartzTrigger() {
    }

    public IntervalSimpleSysQuartzTrigger(Duration duration, Integer repeatCount) {
        this.duration = duration;
        this.repeatCount = repeatCount;
    }

    @Override
    public SysQuartzTriggerType triggerType() {
        return SysQuartzTriggerType.INTERVAL_SIMPLE;
    }

    @Override
    public void validate() {
        Assert.notNull((Object)this.duration, (String)"\u65f6\u95f4\u95f4\u9694\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.isTrue((this.duration.toMillis() > 0L ? 1 : 0) != 0, (String)"\u65f6\u95f4\u95f4\u9694\u4e0d\u80fd\u5c0f\u4e8e0", (Object[])new Object[0]);
        Assert.isTrue((this.repeatCount == null || this.repeatCount != 0 ? 1 : 0) != 0, (String)"\u91cd\u590d\u6b21\u6570\u4e0d\u80fd\u4e3a0", (Object[])new Object[0]);
    }

    @Override
    public Trigger buildTrigger() {
        SimpleTriggerImpl trigger = new SimpleTriggerImpl();
        trigger.setRepeatInterval(this.duration.toMillis());
        if (this.repeatCount == null || this.repeatCount < 0) {
            trigger.setRepeatCount(-1);
        } else {
            trigger.setRepeatCount(this.repeatCount.intValue());
        }
        return trigger;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public void setDuration(Duration duration) {
        this.duration = duration;
    }

    public Integer getRepeatCount() {
        return this.repeatCount;
    }

    public void setRepeatCount(Integer repeatCount) {
        this.repeatCount = repeatCount;
    }
}

