/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.seq.controller;

import com.elitescloud.boot.common.annotation.BusinessObject;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.constant.NextValuePeriod;
import com.elitescloud.cloudt.system.seq.model.vo.query.SeqNumPageQueryVO;
import com.elitescloud.cloudt.system.seq.model.vo.resp.SeqNumPageRespVO;
import com.elitescloud.cloudt.system.seq.model.vo.resp.SeqNumRespVO;
import com.elitescloud.cloudt.system.seq.model.vo.save.SeqNumSaveVO;
import com.elitescloud.cloudt.system.seq.service.SeqNumMngService;
import com.elitescloud.cloudt.system.service.model.entity.SysPlatformNextNumberDO;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4e0b\u4e00\u7f16\u53f7\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/mng/seq/num"}, produces={"application/json"})
@Validated
@BusinessObject(businessType="Sys_SeqNum:\u79df\u6237\u4e0b\u4e00\u7f16\u53f7", businessDoClass=SysPlatformNextNumberDO.class)
public class SeqNumMngController {
    private final SeqNumMngService seqNumMngService;

    public SeqNumMngController(SeqNumMngService seqNumMngService) {
        this.seqNumMngService = seqNumMngService;
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u8bb0\u5f55")
    @ApiOperationSupport(order=1)
    @PostMapping(value={"/page"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT_PAGE, operationDescription="\u5206\u9875\u67e5\u8be2", logEnabled=true, resultJsonEnabled=true, argsJsonEnabled=true)
    public ApiResult<PagingVO<SeqNumPageRespVO>> page(@RequestBody SeqNumPageQueryVO queryVO) {
        return this.seqNumMngService.pageMng(queryVO);
    }

    @ApiOperation(value="\u5207\u6362\u542f\u7528\u7981\u7528")
    @ApiOperationSupport(order=2)
    @ApiImplicitParam(name="id", value="\u8bb0\u5f55ID", required=true, dataType="int")
    @PatchMapping(value={"/switch/enabled/{id}"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.UPDATE, operationDescription="\u5207\u6362\u542f\u7528\u7981\u7528", logEnabled=true, resultJsonEnabled=true, argsJsonEnabled=true)
    public ApiResult<Long> switchEnabled(@PathVariable(value="id") Long id) {
        return this.seqNumMngService.updateEnabled(id);
    }

    @ApiOperation(value="\u5220\u9664\u8bb0\u5f55")
    @ApiOperationSupport(order=3)
    @ApiImplicitParam(name="id", value="\u8bb0\u5f55ID", required=true, dataType="int")
    @DeleteMapping(value={"/del/{id}"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.DELETE, operationDescription="\u5220\u9664\u8bb0\u5f55", logEnabled=true, resultJsonEnabled=true, argsJsonEnabled=true)
    public ApiResult<Long> delete(@PathVariable(value="id") Long id) {
        return this.seqNumMngService.delete(id);
    }

    @ApiOperation(value="\u83b7\u53d6\u8bb0\u5f55\u8be6\u60c5")
    @ApiOperationSupport(order=4)
    @ApiImplicitParam(name="id", value="\u8bb0\u5f55ID", required=true, dataType="int")
    @GetMapping(value={"/get/{id}"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="\u83b7\u53d6\u8bb0\u5f55\u8be6\u60c5", logEnabled=true, resultJsonEnabled=true, argsJsonEnabled=true)
    public ApiResult<SeqNumRespVO> get(@PathVariable(value="id") Long id) {
        return this.seqNumMngService.get(id);
    }

    @ApiOperation(value="\u4fdd\u5b58\u8bb0\u5f55")
    @ApiOperationSupport(order=5)
    @PostMapping(value={"/save"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.SAVE, operationDescription="\u4fdd\u5b58\u8bb0\u5f55", logEnabled=true, resultJsonEnabled=true, argsJsonEnabled=true)
    public ApiResult<Long> save(@RequestBody @Valid SeqNumSaveVO saveVO) {
        return this.seqNumMngService.save(saveVO);
    }

    @ApiOperation(value="\u7f16\u53f7\u5468\u671f")
    @ApiOperationSupport(order=21)
    @GetMapping(value={"/periods"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="\u7f16\u53f7\u5468\u671f")
    public ApiResult<List<CodeNameParam>> numPeriods() {
        List values = Arrays.stream(NextValuePeriod.values()).map(t -> new CodeNameParam(t.name(), t.getDescription())).collect(Collectors.toList());
        return ApiResult.ok(values);
    }
}

