/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.seq.controller;

import com.elitescloud.boot.common.annotation.BusinessObject;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.constant.SysNumType;
import com.elitescloud.cloudt.system.seq.model.vo.query.SeqRulePageQueryVO;
import com.elitescloud.cloudt.system.seq.model.vo.resp.SeqRuleDetailsRespVO;
import com.elitescloud.cloudt.system.seq.model.vo.resp.SeqRulePageRespVO;
import com.elitescloud.cloudt.system.seq.model.vo.save.SeqRuleSaveVO;
import com.elitescloud.cloudt.system.seq.service.SeqRuleMngService;
import com.elitescloud.cloudt.system.service.model.entity.SysPlatformNumberRuleDO;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u53d1\u53f7\u89c4\u5219\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/mng/seq/rule"}, produces={"application/json"})
@Validated
@BusinessObject(businessType="Sys_SeqRule:\u79df\u6237\u53d1\u53f7\u5668", businessDoClass=SysPlatformNumberRuleDO.class)
public class SeqRuleMngController {
    private final SeqRuleMngService seqRuleMngService;

    public SeqRuleMngController(SeqRuleMngService seqRuleMngService) {
        this.seqRuleMngService = seqRuleMngService;
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u8bb0\u5f55")
    @ApiOperationSupport(order=1)
    @PostMapping(value={"/page"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT_PAGE, operationDescription="\u5206\u9875\u67e5\u8be2")
    public ApiResult<PagingVO<SeqRulePageRespVO>> page(@RequestBody SeqRulePageQueryVO queryVO) {
        return this.seqRuleMngService.pageMng(queryVO);
    }

    @ApiOperation(value="\u5207\u6362\u542f\u7528\u7981\u7528")
    @ApiOperationSupport(order=2)
    @ApiImplicitParam(name="id", value="\u8bb0\u5f55ID", required=true, dataType="int")
    @PatchMapping(value={"/switch/enabled/{id}"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.UPDATE, operationDescription="\u5207\u6362\u542f\u7528\u7981\u7528", logEnabled=true, resultJsonEnabled=true, argsJsonEnabled=true)
    public ApiResult<Long> switchEnabled(@PathVariable(value="id") Long id) {
        return this.seqRuleMngService.updateEnabled(id);
    }

    @ApiOperation(value="\u83b7\u53d6\u8bb0\u5f55\u8be6\u60c5")
    @ApiOperationSupport(order=3)
    @ApiImplicitParam(name="id", value="\u8bb0\u5f55ID", required=true, dataType="int")
    @GetMapping(value={"/get/{id}"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="\u83b7\u53d6\u8bb0\u5f55\u8be6\u60c5")
    public ApiResult<SeqRuleDetailsRespVO> get(@PathVariable(value="id") Long id) {
        return this.seqRuleMngService.get(id);
    }

    @ApiOperation(value="\u4fee\u6539\u8bb0\u5f55")
    @ApiOperationSupport(order=6)
    @ApiImplicitParam(name="id", value="\u8bb0\u5f55ID", required=true, dataType="int")
    @PutMapping(value={"/update/{id}"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.UPDATE, operationDescription="\u4fee\u6539\u8bb0\u5f55", logEnabled=true, resultJsonEnabled=true, argsJsonEnabled=true)
    public ApiResult<Long> update(@PathVariable(value="id") Long id, @RequestBody @Valid SeqRuleSaveVO saveVO) {
        return this.seqRuleMngService.update(id, saveVO);
    }

    @ApiOperation(value="\u751f\u6210\u793a\u4f8b\u4ee3\u7801")
    @ApiOperationSupport(order=7)
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u8bb0\u5f55ID", required=true, dataType="int"), @ApiImplicitParam(name="runtimeValues", value="\u8fd0\u884c\u65f6\u53c2\u6570", paramType="body")})
    @PostMapping(value={"/get/{id}/sample"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="\u751f\u6210\u793a\u4f8b\u4ee3\u7801")
    public ApiResult<String> getSampleCode(@PathVariable(value="id") Long id, @RequestBody List<String> runtimeValues) {
        return this.seqRuleMngService.getSample(id, runtimeValues);
    }

    @ApiOperation(value="\u53d6\u53f7\u7c7b\u578b")
    @ApiOperationSupport(order=21)
    @GetMapping(value={"/numType"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="\u53d6\u53f7\u7c7b\u578b")
    public ApiResult<List<CodeNameParam>> numType() {
        List values = Arrays.stream(SysNumType.values()).map(t -> new CodeNameParam(t.name(), t.getDescription())).collect(Collectors.toList());
        return ApiResult.ok(values);
    }
}

