/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.seq.service;

import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.seq.model.bo.SysSeqRuleDtlBO;
import com.elitescloud.cloudt.system.seq.service.repo.SeqNextNumRepoProc;
import com.elitescloud.cloudt.system.seq.service.repo.SeqRuleDtlRepoProc;
import com.elitescloud.cloudt.system.seq.service.repo.SeqRuleRepoProc;
import java.util.List;
import javax.validation.constraints.NotBlank;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@TenantTransaction(isolateType=TenantIsolateType.TENANT)
@TenantOrgTransaction(useTenantOrg=false)
@Service
public class SeqNumGenerateService {
    @Autowired
    private SeqNextNumRepoProc nextNumRepoProc;
    @Autowired
    private SeqRuleDtlRepoProc ruleDtlRepoProc;
    @Autowired
    private SeqRuleRepoProc ruleRepoProc;

    public Long getRuleIdByCode(@NotBlank String appCode, @NotBlank String ruleCode) {
        return this.ruleRepoProc.getIdByRuleCode(appCode, ruleCode);
    }

    public Long getNextNumberIdByCode(@NotBlank String appCode, @NotBlank String nnCode) {
        return this.nextNumRepoProc.getIdByCode(appCode, nnCode);
    }

    public List<SysSeqRuleDtlBO> getRuleDetailsByRuleId(long ruleId) {
        return this.ruleDtlRepoProc.queryBoByRuleId(ruleId);
    }
}

