package com.elitescloud.cloudt.system.quartz.common;

import org.quartz.Job;

/**
 * 任务类型.
 *
 * @author Kaiser（wang shao）
 * @date 2025/9/20 周六
 */
public enum SysQuartzJobEnum implements SysQuartzJobType {
    DEMO("示例", "演示示例"),
    BUSINESS_WARNING_RULE("业务预警规则", "系统(业务)预警中心任务调度"),
    ;

    private final String groupName;
    private final String description;

    SysQuartzJobEnum(String groupName, String description) {
        this.groupName = groupName;
        this.description = description;
    }

    @Override
    public String groupCode() {
        return name();
    }

    @Override
    public String groupName() {
        return groupName;
    }


    @Override
    public String description() {
        return description;
    }
}
