package com.elitescloud.cloudt.system.quartz.model.bo.schedule;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.system.quartz.common.SysQuartzTriggerType;
import org.quartz.Trigger;
import org.quartz.impl.triggers.SimpleTriggerImpl;

import java.io.Serial;
import java.time.Duration;

/**
 * 时间间隔.
 *
 * @author Kaiser（wang shao）
 * @date 2025/10/11 周六
 */
public class IntervalSimpleSysQuartzTrigger implements SysQuartzTrigger {
    @Serial
    private static final long serialVersionUID = 8444748402557028231L;

    /**
     * 时间间隔
     */
    private Duration duration;

    /**
     * 重复次数
     * <p>
     * 小于0标识无限制
     */
    private Integer repeatCount;

    public IntervalSimpleSysQuartzTrigger() {
    }

    public IntervalSimpleSysQuartzTrigger(Duration duration, Integer repeatCount) {
        this.duration = duration;
        this.repeatCount = repeatCount;
    }

    @Override
    public SysQuartzTriggerType triggerType() {
        return SysQuartzTriggerType.INTERVAL_SIMPLE;
    }

    @Override
    public void validate() {
        Assert.notNull(duration, "时间间隔不能为空");
        Assert.isTrue(duration.toMillis() > 0, "时间间隔不能小于0");

        Assert.isTrue(repeatCount == null || repeatCount != 0, "重复次数不能为0");
    }

    @Override
    public Trigger buildTrigger() {
        SimpleTriggerImpl trigger = new SimpleTriggerImpl();
        trigger.setRepeatInterval(duration.toMillis());

        if (repeatCount == null || repeatCount < 0) {
            trigger.setRepeatCount(-1);
        } else {
            trigger.setRepeatCount(repeatCount);
        }

        return trigger;
    }

    public Duration getDuration() {
        return duration;
    }

    public void setDuration(Duration duration) {
        this.duration = duration;
    }

    public Integer getRepeatCount() {
        return repeatCount;
    }

    public void setRepeatCount(Integer repeatCount) {
        this.repeatCount = repeatCount;
    }
}
