package com.elitescloud.cloudt.system.quartz.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.resp.SysQuartzJobRespDTO;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/10/9 周四
 */
public interface SysQuartzQueryService {

    /**
     * 获取任务信息
     *
     * @param jobCode
     * @return
     */
    ApiResult<SysQuartzJobRespDTO> getJob(@NotBlank String jobCode);

    /**
     * 获取下次执行时间
     *
     * @param jobCode
     * @param count
     * @return
     */
    ApiResult<List<String>> getNextFiredTime(@NotBlank String jobCode, Integer count);
}
