package com.elitescloud.cloudt.system.seq.model.vo.resp;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 下一编号.
 *
 * @author Kaiser（wang shao）
 * 2022/9/19
 */
@Data
@ApiModel(description = "下一编号")
public class SeqNumRespVO implements Serializable {
    private static final long serialVersionUID = 8059960769559891887L;

    /**
     * ID
     */
    @ApiModelProperty(value = "ID", position = 1)
    private Long id;

    /**
     * 应用编码
     */
    @ApiModelProperty(value = "应用编码", position = 1)
    private String appCode;

    /**
     * 编码
     */
    @ApiModelProperty(value = "编码", position = 2)
    private String code;

    /**
     * 名称
     */
    @ApiModelProperty(value = "名称", position = 3)
    private String name;

    /**
     * 步长
     */
    @ApiModelProperty(value = "步长", position = 4)
    private Integer step;

    /**
     * 下一编号
     */
    @ApiModelProperty(value = "下一编号", position = 5)
    private Long nextNumber;

    /**
     * 编号周期
     */
    @ApiModelProperty(value = "编号周期", position = 6)
    private String nnPeriod;

    /**
     * 是否启用
     */
    @ApiModelProperty(value = "是否启用", position = 7)
    private Boolean enabled;
}
