package com.elitescloud.cloudt.system.seq.model.vo.save;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 发号规则明细.
 *
 * @author Kaiser（wang shao）
 * 2022/9/19
 */
@Data
@ApiModel(description = "发号规则明细")
public class SeqRuleDetailSaveVO implements Serializable {
    private static final long serialVersionUID = -2324528889607472747L;

    /**
     * 取号类型
     */
    @ApiModelProperty(value = "取号类型", position = 1, required = true)
    @NotBlank(message = "取号类型为空")
    private String numberType;

    /**
     * 取号模式
     */
    @ApiModelProperty(value = "取号模式", position = 2, required = true)
    @NotBlank(message = "取号模式为空")
    private String numberPattern;

    /**
     * 自增序号宽度
     */
    @ApiModelProperty(value = "自增序号宽度", position = 3)
    private Integer nnLen;

    /**
     * 顺序号
     */
    @ApiModelProperty(value = "顺序号", position = 4)
    private Integer seq;
}
