/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.quartz.service.impl;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.util.DatetimeUtil;
import com.elitescloud.boot.util.JSONUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.dto.resp.SysQuartzJobRespDTO;
import com.elitescloud.cloudt.system.quartz.common.SysQuartzTriggerType;
import com.elitescloud.cloudt.system.quartz.model.bo.schedule.CronSysQuartzTrigger;
import com.elitescloud.cloudt.system.quartz.model.bo.schedule.DailyTimeSysQuartzTrigger;
import com.elitescloud.cloudt.system.quartz.model.bo.schedule.IntervalCalendarSysQuartzTrigger;
import com.elitescloud.cloudt.system.quartz.model.bo.schedule.IntervalSimpleSysQuartzTrigger;
import com.elitescloud.cloudt.system.quartz.model.bo.schedule.SysQuartzTrigger;
import com.elitescloud.cloudt.system.quartz.model.entity.SysQuartzJobDO;
import com.elitescloud.cloudt.system.quartz.service.SysQuartzQueryService;
import com.elitescloud.cloudt.system.quartz.service.repo.SysQuartzJobRepoProc;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.quartz.spi.MutableTrigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
@TenantOrgTransaction(useTenantOrg=false)
public class SysQuartzQueryServiceImpl
implements SysQuartzQueryService {
    private static final Logger logger = LoggerFactory.getLogger(SysQuartzQueryServiceImpl.class);
    @Autowired
    private SysQuartzJobRepoProc sysQuartzJobRepoProc;

    @Override
    public ApiResult<SysQuartzJobRespDTO> getJob(String jobCode) {
        SysQuartzJobDO jobDO = this.sysQuartzJobRepoProc.getByJobCode(jobCode);
        if (jobDO == null) {
            return ApiResult.ok(null);
        }
        SysQuartzJobRespDTO respDTO = new SysQuartzJobRespDTO();
        respDTO.setJobCode(jobDO.getJobCode());
        respDTO.setGroupCode(jobDO.getGroupCode());
        respDTO.setJobName(jobDO.getJobName());
        respDTO.setEnabled(jobDO.getEnabled());
        respDTO.setDescription(jobDO.getDescription());
        respDTO.setJobData((Map)JSONUtil.json2Obj((String)jobDO.getJobDataJson(), (TypeReference)new TypeReference<HashMap<String, String>>(){}));
        respDTO.setTriggerType(jobDO.getTriggerType());
        respDTO.setTriggerJson(jobDO.getTriggerJson());
        respDTO.setJobClass(jobDO.getJobClass());
        respDTO.setStarDate(jobDO.getStarDate());
        respDTO.setEndDate(jobDO.getEndDate());
        return ApiResult.ok((Object)respDTO);
    }

    @Override
    public ApiResult<List<String>> getNextFiredTime(String jobCode, Integer count) {
        SysQuartzJobDO jobDO = this.sysQuartzJobRepoProc.getByJobCode(jobCode);
        if (jobDO == null) {
            return ApiResult.ok(Collections.emptyList());
        }
        SysQuartzTrigger sysQuartzTrigger = this.convertTrigger(jobDO.getTriggerType(), jobDO.getTriggerJson());
        if (sysQuartzTrigger == null) {
            return ApiResult.ok(Collections.emptyList());
        }
        if (count == null || count < 0) {
            count = 6;
        }
        Predicate validator = null;
        ArrayList<String> triggerTimes = new ArrayList<String>(count);
        MutableTrigger trigger = (MutableTrigger)sysQuartzTrigger.buildTrigger();
        Date afterTime = new Date();
        while (triggerTimes.size() < count) {
            afterTime = trigger.getFireTimeAfter(afterTime);
            String triggerTime = DatetimeUtil.toStr((Date)afterTime);
            if (validator == null || validator.test(afterTime)) {
                triggerTimes.add(triggerTime);
                continue;
            }
            logger.info("\u4e0b\u4e00\u6b21\u89e6\u53d1\u65f6\u95f4\uff1a{}\uff0c\u4e0d\u6ee1\u8db3\u6761\u4ef6\uff0c\u8df3\u8fc7", (Object)triggerTime);
        }
        return ApiResult.ok(triggerTimes);
    }

    private SysQuartzTrigger convertTrigger(String triggerType, String triggerJson) {
        if (StrUtil.isBlank((CharSequence)triggerType) || StrUtil.isBlank((CharSequence)triggerJson)) {
            return null;
        }
        SysQuartzTriggerType triggerTypeEnum = SysQuartzTriggerType.getByValue(triggerType);
        Assert.notNull((Object)((Object)triggerTypeEnum), (String)"\u89e6\u53d1\u5668\u7c7b\u578b\u9519\u8bef", (Object[])new Object[0]);
        return switch (triggerTypeEnum) {
            case SysQuartzTriggerType.CRON -> (CronSysQuartzTrigger)JSONUtil.json2Obj((String)triggerJson, (TypeReference)new TypeReference<CronSysQuartzTrigger>(){});
            case SysQuartzTriggerType.INTERVAL_SIMPLE -> (IntervalSimpleSysQuartzTrigger)JSONUtil.json2Obj((String)triggerJson, (TypeReference)new TypeReference<IntervalSimpleSysQuartzTrigger>(){});
            case SysQuartzTriggerType.INTERVAL_CALENDAR -> (IntervalCalendarSysQuartzTrigger)JSONUtil.json2Obj((String)triggerJson, (TypeReference)new TypeReference<IntervalCalendarSysQuartzTrigger>(){});
            case SysQuartzTriggerType.INTERVAL_DAILY_TIME -> (DailyTimeSysQuartzTrigger)JSONUtil.json2Obj((String)triggerJson, (TypeReference)new TypeReference<DailyTimeSysQuartzTrigger>(){});
            default -> throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u89e6\u53d1\u5668\u7c7b\u578b");
        };
    }
}

