/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.seq.common;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.util.LockUtil;
import com.elitescloud.cloudt.system.constant.SysNumType;
import com.elitescloud.cloudt.system.seq.model.bo.SysSeqRuleDtlBO;
import com.elitescloud.cloudt.system.seq.service.NextNumGenerateService;
import com.elitescloud.cloudt.system.seq.service.SeqNumGenerateService;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

@Component
public class SeqNumFactory {
    private static final Logger log = LogManager.getLogger(SeqNumFactory.class);
    private static final Map<String, DateTimeFormatter> FORMATTER_MAP = new HashMap<String, DateTimeFormatter>();
    private static final String PLACEHOLDER_NEXT_NUMBER = "##{NN}##";
    @Autowired
    private NextNumGenerateService generateService;
    @Autowired
    private SeqNumGenerateService supportService;

    public String generateSampleCode(@NotNull Long ruleId, List<String> runtimeValues) {
        Assert.notNull((Object)ruleId, (String)"\u53d1\u53f7\u89c4\u5219ID\u4e3a\u7a7a");
        List<String> values = this.executeGenerateCode(ruleId, d -> List.of(Long.valueOf(1L)), runtimeValues, 1);
        if (CollUtil.isNotEmpty(values)) {
            return values.get(0);
        }
        return null;
    }

    public String generateSampleCode(@NotBlank String appCode, @NotBlank String ruleCode, List<String> runtimeValues) {
        Assert.hasText((String)appCode, (String)"\u5e94\u7528\u7f16\u7801\u4e3a\u7a7a");
        Assert.hasText((String)ruleCode, (String)"\u89c4\u5219\u7f16\u7801\u4e3a\u7a7a");
        Long ruleId = this.supportService.getRuleIdByCode(appCode, ruleCode);
        Assert.notNull((Object)ruleId, (String)"\u53d1\u53f7\u89c4\u5219\u4e0d\u5b58\u5728");
        return this.generateSampleCode(ruleId, runtimeValues);
    }

    public String generateCode(@NotNull Long ruleId, List<String> runtimeValues) {
        List<String> values = this.generateCode(ruleId, runtimeValues, 1);
        if (CollUtil.isNotEmpty(values)) {
            return values.get(0);
        }
        return null;
    }

    public List<String> generateCode(@NotNull Long ruleId, List<String> runtimeValues, int num) {
        Assert.notNull((Object)ruleId, (String)"\u53d1\u53f7\u89c4\u5219ID\u4e3a\u7a7a");
        StopWatch watch = new StopWatch();
        watch.start();
        List<String> code = this.executeGenerateCode(ruleId, d -> {
            try {
                return this.nextValue(d.getAppCode(), d.getNumberPattern(), d.getNnLen(), num);
            }
            catch (Exception e) {
                log.error("\u751f\u6210\u4e0b\u4e00\u7f16\u53f7\u5931\u8d25\uff1a{}", (Object)e.getMessage());
                throw new BusinessException("\u751f\u6210\u4e0b\u4e00\u7f16\u53f7\u5931\u8d25", (Throwable)e);
            }
        }, runtimeValues, num);
        watch.stop();
        log.info("\u53d1\u53f7\u5b8c\u6210\uff0c\u8017\u65f6{}ms", (Object)watch.getTotalTimeMillis());
        return code;
    }

    public String generateCode(@NotBlank String appCode, @NotBlank String ruleCode, List<String> runtimeValues) {
        List<String> values = this.generateCode(appCode, ruleCode, runtimeValues, 1);
        if (CollUtil.isNotEmpty(values)) {
            return values.get(0);
        }
        return null;
    }

    public List<String> generateCode(@NotBlank String appCode, @NotBlank String ruleCode, List<String> runtimeValues, int num) {
        Assert.hasText((String)appCode, (String)"\u5e94\u7528\u7f16\u7801\u4e3a\u7a7a");
        Assert.hasText((String)ruleCode, (String)"\u89c4\u5219\u7f16\u7801\u4e3a\u7a7a");
        Long ruleId = this.supportService.getRuleIdByCode(appCode, ruleCode);
        if (ruleId == null) {
            throw new BusinessException("\u53d1\u53f7\u89c4\u5219\u4e0d\u5b58\u5728");
        }
        return this.generateCode(ruleId, runtimeValues, num);
    }

    public Long nextValue(@NotNull Long nnId, Integer nnLen) {
        List<Long> values = this.nextValue(nnId, nnLen, 1);
        if (CollUtil.isNotEmpty(values)) {
            return values.get(0);
        }
        return null;
    }

    public List<Long> nextValue(@NotNull Long nnId, Integer nnLen, int num) {
        Assert.notNull((Object)nnId, (String)"\u4e0b\u4e00\u5e8f\u53f7\u7684ID\u4e3a\u7a7a");
        Assert.isTrue((num > 0 ? 1 : 0) != 0, (String)"\u4e0b\u4e00\u5e8f\u53f7\u7684\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e1");
        String lockKey = "nv:" + nnId;
        List valueList = null;
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            valueList = this.executeByLock(() -> this.generateService.nextNumber(nnId, nnLen, num), lockKey);
        }
        catch (InterruptedException e) {
            stopWatch.stop();
            log.error("{}\u751f\u6210\u4e0b\u4e00\u5e8f\u53f7\u5f02\u5e38\uff1a{}\uff0c\u8017\u65f6{}ms", (Object)nnId, (Object)e.getMessage(), (Object)stopWatch.getTotalTimeMillis());
            throw new BusinessException("\u751f\u6210\u4e0b\u4e00\u5e8f\u53f7\u5f02\u5e38", (Throwable)e);
        }
        stopWatch.stop();
        log.info("{}\u751f\u6210\u4e0b\u4e00\u5e8f\u53f7\u7ed3\u675f\uff0c\u8017\u65f6\uff1a{}ms", (Object)nnId, (Object)stopWatch.getTotalTimeMillis());
        if (CollectionUtils.isEmpty((Collection)valueList)) {
            throw new BusinessException("\u751f\u6210\u4e0b\u4e00\u5e8f\u53f7\u5931\u8d25");
        }
        return valueList;
    }

    public Long nextValue(@NotBlank String appCode, @NotBlank String nnCode, Integer nnlen) {
        return this.nextValue(appCode, nnCode, nnlen, false);
    }

    public List<Long> nextValue(@NotBlank String appCode, @NotBlank String nnCode, Integer nnlen, int num) {
        return this.nextValue(appCode, nnCode, nnlen, false, num);
    }

    public Long nextValue(@NotBlank String appCode, @NotBlank String nnCode, Integer nnlen, boolean createOnNotExists) {
        List<Long> values = this.nextValue(appCode, nnCode, nnlen, createOnNotExists, 1);
        if (CollUtil.isNotEmpty(values)) {
            return values.get(0);
        }
        return null;
    }

    public List<Long> nextValue(@NotBlank String appCode, @NotBlank String nnCode, Integer nnlen, boolean createOnNotExists, int num) {
        Assert.hasText((String)appCode, (String)"\u5e94\u7528\u7f16\u7801\u4e3a\u7a7a");
        Assert.hasText((String)nnCode, (String)"\u4e0b\u4e00\u5e8f\u53f7\u7684\u7f16\u7801\u4e3a\u7a7a");
        Long id = this.supportService.getNextNumberIdByCode(appCode, nnCode);
        if (id != null) {
            return this.nextValue(id, nnlen, num);
        }
        Assert.isTrue((boolean)createOnNotExists, (String)("\u672a\u627e\u5230" + nnCode + "\u4e0b\u4e00\u5e8f\u53f7"));
        id = this.createNextValue(appCode, nnCode);
        return this.nextValue(id, nnlen, num);
    }

    private Long createNextValue(String appCode, String nnCode) {
        String lockKey = CharSequenceUtil.blankToDefault((CharSequence)appCode, (String)"def") + ":nn:" + nnCode;
        try {
            return this.executeByLock(() -> {
                Long id = this.supportService.getNextNumberIdByCode(appCode, nnCode);
                if (id != null) {
                    return id;
                }
                id = this.generateService.createNextNumberForInit(appCode, nnCode);
                if (id == null) {
                    id = this.supportService.getNextNumberIdByCode(appCode, nnCode);
                }
                return id;
            }, lockKey);
        }
        catch (InterruptedException e) {
            log.error("\u521b\u5efa\u4e0b\u4e00\u5e8f\u53f7\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new BusinessException("\u521b\u5efa\u4e0b\u4e00\u5e8f\u53f7\u5f02\u5e38", (Throwable)e);
        }
    }

    private List<String> executeGenerateCode(@NonNull Long ruleId, Function<SysSeqRuleDtlBO, List<Long>> nextNumberFunction, List<String> runtimeValues, int num) {
        Assert.notNull((Object)ruleId, (String)"\u53d1\u53f7\u5668\u89c4\u5219ID\u4e3a\u7a7a");
        Assert.isTrue((num > 0 ? 1 : 0) != 0, (String)"\u53d1\u53f7\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e1");
        List<SysSeqRuleDtlBO> ruleDetails = this.supportService.getRuleDetailsByRuleId(ruleId);
        Assert.isTrue((!ruleDetails.isEmpty() ? 1 : 0) != 0, (String)"\u672a\u67e5\u8be2\u5230\u53d1\u53f7\u89c4\u5219\u914d\u7f6e");
        return this.executeGenerateCode(ruleId, ruleDetails, nextNumberFunction, runtimeValues, num);
    }

    private List<String> executeGenerateCode(@NonNull Long ruleId, @NotEmpty List<SysSeqRuleDtlBO> ruleDetails, Function<SysSeqRuleDtlBO, List<Long>> nextNumberFunction, List<String> runtimeValues, int num) {
        StringBuilder code = new StringBuilder();
        SysSeqRuleDtlBO lastNextNumberRuleDtl = null;
        if (num > 1) {
            lastNextNumberRuleDtl = this.obtainLastNextNumberRuleDtl(ruleDetails);
            Assert.notNull((Object)lastNextNumberRuleDtl, (String)"\u6279\u91cf\u53d1\u53f7\u5931\u8d25\uff0c\u672a\u53d1\u73b0\u9012\u589e\u5e8f\u53f7\u914d\u7f6e");
        }
        int offset = 0;
        block7: for (SysSeqRuleDtlBO ruleDetail : ruleDetails) {
            Integer len;
            Assert.state((boolean)StringUtils.hasText((String)ruleDetail.getNumberType()), (String)("\u53d1\u53f7\u5668\u89c4\u5219\u3010" + ruleId + "\u3011\u914d\u7f6e\u6709\u8bef\uff0c\u53d6\u53f7\u7c7b\u578b\u4e3a\u7a7a"));
            LocalDateTime now = LocalDateTime.now();
            String pattern = ruleDetail.getNumberPattern();
            SysNumType numType = SysNumType.parse((String)ruleDetail.getNumberType());
            Assert.notNull((Object)numType, (String)("\u672a\u77e5\u89c4\u5219\u7c7b\u578b\uff1a" + ruleDetail.getNumberType()));
            switch (numType) {
                case FS: {
                    if (!StringUtils.hasText((String)pattern)) {
                        throw new BusinessException("\u53d1\u53f7\u5668\u89c4\u5219\u3010" + ruleId + "\u3011\u914d\u7f6e\u6709\u8bef\uff0c\u56fa\u5b9a\u503c\u7684\u6a21\u5f0f\u4e3a\u7a7a");
                    }
                    code.append(pattern);
                    continue block7;
                }
                case DP: {
                    if (!StringUtils.hasText((String)pattern)) {
                        throw new BusinessException("\u53d1\u53f7\u5668\u89c4\u5219\u3010" + ruleId + "\u3011\u914d\u7f6e\u6709\u8bef\uff0c\u65e5\u671f\u683c\u5f0f\u7684\u6a21\u5f0f\u4e3a\u7a7a");
                    }
                    code.append(FORMATTER_MAP.computeIfAbsent(pattern, DateTimeFormatter::ofPattern).format(now));
                    continue block7;
                }
                case NN: {
                    len = ruleDetail.getNnLen();
                    if (len == null) {
                        throw new BusinessException("\u53d1\u53f7\u5668\u89c4\u5219\u3010" + ruleId + "\u3011\u914d\u7f6e\u6709\u8bef\uff0c\u81ea\u589e\u5e8f\u53f7\u5bbd\u5ea6\u4e3a\u7a7a");
                    }
                    if (lastNextNumberRuleDtl != null && lastNextNumberRuleDtl.getId().longValue() == ruleDetail.getId().longValue()) {
                        code.append(PLACEHOLDER_NEXT_NUMBER);
                        continue block7;
                    }
                    List<Long> nextNumbers = nextNumberFunction.apply(ruleDetail);
                    if (CollUtil.isEmpty(nextNumbers)) {
                        throw new BusinessException("\u751f\u6210\u4e0b\u4e00\u7f16\u53f7\u5931\u8d25");
                    }
                    code.append(this.preZero(nextNumbers.get(0), len));
                    continue block7;
                }
            }
            if (runtimeValues == null || offset >= runtimeValues.size()) continue;
            if (CharSequenceUtil.equals((CharSequence)"NN", (CharSequence)pattern)) {
                len = ruleDetail.getNnLen();
                if (len == null) {
                    throw new BusinessException("\u53d1\u53f7\u5668\u89c4\u5219\u3010" + ruleId + "\u3011\u914d\u7f6e\u6709\u8bef\uff0c\u81ea\u589e\u5e8f\u53f7\u5bbd\u5ea6\u4e3a\u7a7a");
                }
                String nnCode = runtimeValues.get(offset);
                Long nextNumber = null;
                try {
                    nextNumber = this.nextValue(ruleDetail.getAppCode(), nnCode, len, true);
                }
                catch (Exception e) {
                    log.error("\u751f\u6210\u4e0b\u4e00\u7f16\u53f7\u5931\u8d25\uff1a{}", (Object)e.getMessage());
                    throw new BusinessException("\u751f\u6210\u4e0b\u4e00\u7f16\u53f7\u5931\u8d25", (Throwable)e);
                }
                code.append(this.preZero(nextNumber, len));
            } else {
                code.append(runtimeValues.get(offset));
            }
            ++offset;
        }
        if (lastNextNumberRuleDtl == null) {
            return List.of(code.toString());
        }
        return this.produceCodeBatch(code.toString(), lastNextNumberRuleDtl, nextNumberFunction);
    }

    private List<String> produceCodeBatch(String code, SysSeqRuleDtlBO ruleDtl, Function<SysSeqRuleDtlBO, List<Long>> nextNumberFunction) {
        List<Long> nextNumberList = nextNumberFunction.apply(ruleDtl);
        Assert.notEmpty(nextNumberList, (String)"\u751f\u6210\u4e0b\u4e00\u7f16\u53f7\u5931\u8d25");
        ArrayList<String> codeList = new ArrayList<String>();
        for (Long nextNumber : nextNumberList) {
            codeList.add(code.replace(PLACEHOLDER_NEXT_NUMBER, this.preZero(nextNumber, ruleDtl.getNnLen())));
        }
        return codeList;
    }

    private SysSeqRuleDtlBO obtainLastNextNumberRuleDtl(List<SysSeqRuleDtlBO> ruleDetails) {
        for (int i = ruleDetails.size() - 1; i >= 0; --i) {
            SysSeqRuleDtlBO dtl = ruleDetails.get(i);
            if (!SysNumType.NN.name().equals(dtl.getNumberType())) continue;
            return dtl;
        }
        return null;
    }

    private String preZero(long val, int len) {
        Assert.isTrue((len > 0 ? 1 : 0) != 0, (String)"\u5bbd\u5ea6\u5fc5\u987b\u5927\u4e8e0");
        String format = "%0" + len + "d";
        return String.format(format, val);
    }

    private <T> T executeByLock(Supplier<T> supplier, String lockName) throws InterruptedException {
        return (T)LockUtil.executeByLock((String)lockName, supplier, (Duration)Duration.ofMinutes(30L), (String)"\u5f53\u524d\u8bf7\u6c42\u91cf\u8fc7\u5927\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
    }
}

