/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.seq.service.impl;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.seq.convert.SeqNumConvert;
import com.elitescloud.cloudt.system.seq.model.vo.query.SeqNumPageQueryVO;
import com.elitescloud.cloudt.system.seq.model.vo.resp.SeqNumPageRespVO;
import com.elitescloud.cloudt.system.seq.model.vo.resp.SeqNumRespVO;
import com.elitescloud.cloudt.system.seq.model.vo.save.SeqNumSaveVO;
import com.elitescloud.cloudt.system.seq.service.SeqNumMngService;
import com.elitescloud.cloudt.system.seq.service.repo.SeqNextNumRepoProc;
import com.elitescloud.cloudt.system.seq.service.repo.SeqRuleDtlRepoProc;
import com.elitescloud.cloudt.system.service.model.entity.SysPlatformNextNumberDO;
import java.io.Serializable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@TenantTransaction(isolateType=TenantIsolateType.TENANT)
@TenantOrgTransaction(useTenantOrg=false)
public class SeqNumMngServiceImpl
extends BaseServiceImpl
implements SeqNumMngService {
    private static final Logger log = LogManager.getLogger(SeqNumMngServiceImpl.class);
    private static final SeqNumConvert CONVERT = SeqNumConvert.INSTANCE;
    @Autowired
    private SeqNextNumRepoProc seqNumRepoProc;
    @Autowired
    private SeqRuleDtlRepoProc seqNumRuleDtlRepoProc;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> save(SeqNumSaveVO saveVO) {
        SysPlatformNextNumberDO numberDO = saveVO.getId() == null ? this.checkForAdd(saveVO) : this.checkForUpdate(saveVO);
        this.seqNumRepoProc.save((Serializable)numberDO);
        return ApiResult.ok((Object)numberDO.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updateEnabled(Long id) {
        Boolean enabled = this.seqNumRepoProc.getEnabled(id);
        enabled = enabled == null || enabled == false;
        this.seqNumRepoProc.updateEnabled(id, enabled);
        return ApiResult.ok((Object)id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> delete(Long id) {
        SysPlatformNextNumberDO numberDO = (SysPlatformNextNumberDO)this.seqNumRepoProc.get(id);
        if (numberDO == null) {
            return ApiResult.noData();
        }
        if (((Boolean)ObjectUtil.defaultIfNull((Object)numberDO.getInternal(), (Object)true)).booleanValue()) {
            return ApiResult.fail((String)"\u5185\u7f6e\u6570\u636e\u4e0d\u53ef\u5220\u9664");
        }
        boolean isInUse = this.seqNumRuleDtlRepoProc.isInUseForNextNum(numberDO.getAppCode(), numberDO.getCode());
        if (isInUse) {
            return ApiResult.fail((String)"\u8be5\u7f16\u53f7\u6b63\u5728\u4f7f\u7528\u4e2d\uff0c\u8bf7\u5148\u4fee\u6539\u5173\u8054\u7684\u53d1\u53f7\u89c4\u5219");
        }
        this.seqNumRepoProc.delete(id);
        return ApiResult.ok((Object)id);
    }

    @Override
    public ApiResult<SeqNumRespVO> get(Long id) {
        SysPlatformNextNumberDO seqNum = (SysPlatformNextNumberDO)this.seqNumRepoProc.get(id);
        if (seqNum == null) {
            return ApiResult.noData();
        }
        SeqNumRespVO respVO = CONVERT.do2DetailRespVO(seqNum);
        return ApiResult.ok((Object)respVO);
    }

    @Override
    public ApiResult<PagingVO<SeqNumPageRespVO>> pageMng(SeqNumPageQueryVO queryVO) {
        PagingVO pageData = this.seqNumRepoProc.pageMng(queryVO).map(CONVERT::do2MngRespVO);
        return ApiResult.ok((Object)pageData);
    }

    private SysPlatformNextNumberDO checkForAdd(SeqNumSaveVO saveVO) {
        boolean exists = this.seqNumRepoProc.existsCode(saveVO.getAppCode(), saveVO.getCode());
        Assert.isTrue((!exists ? 1 : 0) != 0, (String)"\u7f16\u53f7\u5df2\u5b58\u5728");
        if (saveVO.getEnabled() == null) {
            saveVO.setEnabled(true);
        }
        SysPlatformNextNumberDO nextNumberDO = CONVERT.saveVo2Do(saveVO);
        nextNumberDO.setVersion(Integer.valueOf(1));
        nextNumberDO.setInternal(Boolean.valueOf(false));
        return nextNumberDO;
    }

    private SysPlatformNextNumberDO checkForUpdate(SeqNumSaveVO saveVO) {
        SysPlatformNextNumberDO old = (SysPlatformNextNumberDO)this.seqNumRepoProc.get(saveVO.getId());
        Assert.notNull((Object)old, (String)"\u4fee\u6539\u7684\u6570\u636e\u4e0d\u5b58\u5728");
        saveVO.setAppCode(old.getAppCode());
        if (!CharSequenceUtil.equals((CharSequence)old.getCode(), (CharSequence)saveVO.getCode())) {
            boolean exists = this.seqNumRepoProc.existsCode(saveVO.getAppCode(), saveVO.getCode());
            Assert.isTrue((!exists ? 1 : 0) != 0, (String)"\u7f16\u53f7\u5df2\u5b58\u5728");
        }
        if (saveVO.getEnabled() == null) {
            saveVO.setEnabled((Boolean)ObjectUtil.defaultIfNull((Object)old.getEnabled(), (Object)true));
        }
        CONVERT.copySaveVo2Do(saveVO, old);
        return old;
    }
}

