/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.quartz.service.provider;

import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.util.DatetimeUtil;
import com.elitescloud.boot.util.ExceptionsUtil;
import com.elitescloud.boot.util.JSONUtil;
import com.elitescloud.cloudt.system.quartz.common.SysQuartzJobFiredType;
import com.elitescloud.cloudt.system.quartz.model.entity.SysQuartzJobDO;
import com.elitescloud.cloudt.system.quartz.model.entity.SysQuartzTriggerRecordDO;
import com.elitescloud.cloudt.system.quartz.service.repo.SysQuartzJobRepoProc;
import com.elitescloud.cloudt.system.quartz.service.repo.SysQuartzTriggerRecordRepoProc;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.support.TransactionTemplate;

public class SysQuartzJobDelegate
implements Job {
    private static final Logger logger = LoggerFactory.getLogger(SysQuartzJobDelegate.class);
    private TransactionTemplate transactionTemplate;
    private SysQuartzJobRepoProc sysQuartzJobRepoProc;
    private SysQuartzTriggerRecordRepoProc sysQuartzTriggerRecordRepoProc;
    private final Map<String, Job> jobInstanceMap = new HashMap<String, Job>(64);

    public void execute(JobExecutionContext context) throws JobExecutionException {
        String jobCode = context.getJobDetail().getKey().getName();
        logger.info("\u4efb\u52a1\u8c03\u5ea6\u5f00\u59cb\uff1a{}", (Object)jobCode);
        Long recordId = this.initTriggerRecord(context);
        SysQuartzJobDO jobInfo = this.getSysQuartzJobRepoProc().getByJobCode(jobCode);
        if (jobInfo == null) {
            logger.error("\u4efb\u52a1\u4e0d\u5b58\u5728: {}", (Object)jobCode);
            this.getSysQuartzTriggerRecordRepoProc().updateFailed(recordId, "\u4efb\u52a1\u4e0d\u5b58\u5728", null);
            return;
        }
        if (Boolean.FALSE.equals(jobInfo.getEnabled())) {
            logger.error("\u4efb\u52a1\u5df2\u7981\u7528\uff1a{}", (Object)jobCode);
            this.getSysQuartzTriggerRecordRepoProc().updateFailed(recordId, "\u4efb\u52a1\u5df2\u7981\u7528", null);
            return;
        }
        Job job = null;
        try {
            job = this.getJob(jobInfo.getJobClass());
        }
        catch (Exception e) {
            logger.error("\u4efb\u52a1\u6267\u884c\u5668\u52a0\u8f7d\u5931\u8d25\uff1a{}, {}", new Object[]{jobCode, jobInfo.getJobClass(), e});
            this.getSysQuartzTriggerRecordRepoProc().updateFailed(recordId, e.getMessage(), ExceptionsUtil.stackTraceAllToString((Throwable)e));
            return;
        }
        try {
            job.execute(context);
            this.getSysQuartzTriggerRecordRepoProc().updateSuccess(recordId);
        }
        catch (JobExecutionException e) {
            logger.error("\u4efb\u52a1\u6267\u884c\u5668\u6267\u884c\u5f02\u5e38\uff1a{}, {}", new Object[]{jobCode, jobInfo.getJobClass(), e});
            this.getSysQuartzTriggerRecordRepoProc().updateFailed(recordId, e.getMessage(), ExceptionsUtil.stackTraceAllToString((Throwable)e));
            return;
        }
    }

    private SysQuartzJobFiredType obtainFiredType(JobExecutionContext context) {
        JobDataMap mergedJobData = context.getMergedJobDataMap();
        boolean runOnce = mergedJobData.getBooleanValue("__runonce");
        if (runOnce) {
            return SysQuartzJobFiredType.MANUAL_RUNONCE;
        }
        if (context.isRecovering()) {
            return SysQuartzJobFiredType.QUARTZ_RECOVERY;
        }
        return SysQuartzJobFiredType.QUARTZ;
    }

    private Long initTriggerRecord(JobExecutionContext context) {
        SysQuartzTriggerRecordDO recordDO = new SysQuartzTriggerRecordDO();
        recordDO.setJobCode(context.getJobDetail().getKey().getName());
        recordDO.setFireTime(DatetimeUtil.date2LocalDateTime((Date)context.getFireTime()));
        recordDO.setScheduledTime(DatetimeUtil.date2LocalDateTime((Date)context.getScheduledFireTime()));
        recordDO.setFiredType(this.obtainFiredType(context).name());
        recordDO.setSuccess(false);
        recordDO.setJobDataMap(JSONUtil.toJsonString((Object)context.getJobDetail().getJobDataMap()));
        recordDO.setTriggerJobDataMap(JSONUtil.toJsonString((Object)context.getTrigger().getJobDataMap()));
        this.getSysQuartzTriggerRecordRepoProc().save((Serializable)((Object)recordDO));
        return recordDO.getId();
    }

    private SysQuartzJobRepoProc getSysQuartzJobRepoProc() {
        if (this.sysQuartzJobRepoProc == null) {
            this.sysQuartzJobRepoProc = (SysQuartzJobRepoProc)((Object)SpringContextHolder.getBean(SysQuartzJobRepoProc.class));
        }
        return this.sysQuartzJobRepoProc;
    }

    private SysQuartzTriggerRecordRepoProc getSysQuartzTriggerRecordRepoProc() {
        if (this.sysQuartzTriggerRecordRepoProc == null) {
            this.sysQuartzTriggerRecordRepoProc = (SysQuartzTriggerRecordRepoProc)((Object)SpringContextHolder.getBean(SysQuartzTriggerRecordRepoProc.class));
        }
        return this.sysQuartzTriggerRecordRepoProc;
    }

    private TransactionTemplate getTransactionTemplate() {
        if (this.transactionTemplate == null) {
            this.transactionTemplate = (TransactionTemplate)SpringContextHolder.getBean(TransactionTemplate.class);
        }
        return this.transactionTemplate;
    }

    public Job getJob(String jobClassName) {
        Job job = this.jobInstanceMap.get(jobClassName);
        if (job != null) {
            return job;
        }
        Constructor<?> constructor = null;
        try {
            Class<?> jobClass = Class.forName(jobClassName);
            constructor = jobClass.getConstructor(new Class[0]);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("\u4efb\u52a1\u7c7b\u4e0d\u5b58\u5728\uff1a" + jobClassName);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("\u4efb\u52a1\u7c7b\u4e0d\u5b58\u5728\u65e0\u53c2\u6784\u9020\u65b9\u6cd5\uff1a" + jobClassName);
        }
        try {
            job = (Job)constructor.newInstance(new Object[0]);
            logger.info("\u4efb\u52a1\u7c7b\u5b9e\u4f8b\u5316\u6210\u529f\uff1a{}", (Object)jobClassName);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IllegalArgumentException("\u4efb\u52a1\u7c7b\u5b9e\u4f8b\u5316\u5f02\u5e38\uff1a" + jobClassName);
        }
        this.jobInstanceMap.put(jobClassName, job);
        return job;
    }
}

