package com.elitescloud.cloudt.system.seq.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.seq.model.vo.query.SeqNumPageQueryVO;
import com.elitescloud.cloudt.system.seq.model.vo.resp.SeqNumPageRespVO;
import com.elitescloud.cloudt.system.seq.model.vo.resp.SeqNumRespVO;
import com.elitescloud.cloudt.system.seq.model.vo.save.SeqNumSaveVO;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/11/14
 */
public interface SeqNumMngService {

    /**
     * 保存数据
     *
     * @param saveVO 数据信息
     * @return ID
     */
    ApiResult<Long> save(SeqNumSaveVO saveVO);

    /**
     * 切换启用状态
     *
     * @param id ID
     * @return ID
     */
    ApiResult<Long> updateEnabled(Long id);

    /**
     * 删除
     *
     * @param id ID
     * @return ID
     */
    ApiResult<Long> delete(Long id);

    /**
     * 获取详情
     *
     * @param id ID
     * @return 详情
     */
    ApiResult<SeqNumRespVO> get(Long id);

    /**
     * 分页查询下一编号
     *
     * @param queryVO 查询参数
     * @return 下一编号列表
     */
    ApiResult<PagingVO<SeqNumPageRespVO>> pageMng(SeqNumPageQueryVO queryVO);
}
