/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.seq.service.impl;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.constant.SysNumType;
import com.elitescloud.cloudt.system.seq.common.SeqNumFactory;
import com.elitescloud.cloudt.system.seq.convert.SeqRuleConvert;
import com.elitescloud.cloudt.system.seq.model.vo.query.SeqRulePageQueryVO;
import com.elitescloud.cloudt.system.seq.model.vo.resp.SeqRuleDetailRecordRespVO;
import com.elitescloud.cloudt.system.seq.model.vo.resp.SeqRuleDetailsRespVO;
import com.elitescloud.cloudt.system.seq.model.vo.resp.SeqRulePageRespVO;
import com.elitescloud.cloudt.system.seq.model.vo.save.SeqRuleDetailSaveVO;
import com.elitescloud.cloudt.system.seq.model.vo.save.SeqRuleSaveVO;
import com.elitescloud.cloudt.system.seq.service.SeqRuleMngService;
import com.elitescloud.cloudt.system.seq.service.repo.SeqNextNumRepoProc;
import com.elitescloud.cloudt.system.seq.service.repo.SeqRuleDtlRepoProc;
import com.elitescloud.cloudt.system.seq.service.repo.SeqRuleRepoProc;
import com.elitescloud.cloudt.system.service.model.entity.SysPlatformNumberRuleDO;
import com.elitescloud.cloudt.system.service.model.entity.SysPlatformNumberRuleDtlDO;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@TenantTransaction(isolateType=TenantIsolateType.TENANT)
@TenantOrgTransaction(useTenantOrg=false)
public class SeqRuleMngServiceImpl
extends BaseServiceImpl
implements SeqRuleMngService {
    private static final Logger log = LogManager.getLogger(SeqRuleMngServiceImpl.class);
    private static final SeqRuleConvert CONVERT = SeqRuleConvert.INSTANCE;
    @Autowired
    private SeqNextNumRepoProc seqNumRepoProc;
    @Autowired
    private SeqRuleRepoProc seqRuleRepoProc;
    @Autowired
    private SeqRuleDtlRepoProc seqRuleDtlRepoProc;
    @Autowired
    private SeqNumFactory seqNumFactory;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> update(Long id, SeqRuleSaveVO saveVO) {
        SysPlatformNumberRuleDO ruleDO = (SysPlatformNumberRuleDO)this.seqRuleRepoProc.get(id);
        if (ruleDO == null) {
            return ApiResult.noData();
        }
        Assert.notEmpty(saveVO.getDetailsList(), (String)"\u89c4\u5219\u660e\u7ec6\u5217\u8868\u4e3a\u7a7a");
        if (saveVO.getEnabled() == null) {
            saveVO.setEnabled(true);
        }
        CONVERT.copySaveVo(saveVO, ruleDO);
        this.seqRuleRepoProc.save((Serializable)ruleDO);
        this.seqRuleDtlRepoProc.deleteByRuleId(id);
        AtomicInteger sortNo = new AtomicInteger(1);
        List detailDoList = saveVO.getDetailsList().stream().map(t -> {
            SysPlatformNumberRuleDtlDO detailDO = CONVERT.saveVo2Do((SeqRuleDetailSaveVO)t);
            detailDO.setRuleId(ruleDO.getId());
            detailDO.setAppCode(ruleDO.getAppCode());
            if (t.getSeq() == null) {
                detailDO.setSeq(Integer.valueOf(sortNo.getAndIncrement()));
            }
            if (CharSequenceUtil.equals((CharSequence)detailDO.getNumberType(), (CharSequence)SysNumType.NN.name())) {
                Assert.isTrue((detailDO.getNnLen() != null && detailDO.getNnLen() > 0 ? 1 : 0) != 0, (String)"\u53d6\u53f7\u7c7b\u578b\u662f[\u4e0b\u4e00\u7f16\u53f7]\u65f6\u81ea\u589e\u5e8f\u53f7\u5bbd\u5ea6\u4e0d\u80fd\u5c0f\u4e8e0");
                boolean exists = this.seqNumRepoProc.existsCode(detailDO.getAppCode(), detailDO.getNumberPattern());
                Assert.isTrue((boolean)exists, (String)"\u9009\u62e9\u7684\u4e0b\u4e00\u7f16\u53f7\u4e0d\u5b58\u5728");
            }
            return detailDO;
        }).collect(Collectors.toList());
        this.seqRuleDtlRepoProc.save(detailDoList);
        return ApiResult.ok((Object)id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updateEnabled(Long id) {
        Boolean enabled = this.seqRuleRepoProc.getEnabled(id);
        enabled = enabled == null || enabled == false;
        this.seqRuleRepoProc.updateEnabled(id, enabled);
        return ApiResult.ok((Object)id);
    }

    @Override
    public ApiResult<SeqRuleDetailsRespVO> get(Long id) {
        SysPlatformNumberRuleDO ruleDO = (SysPlatformNumberRuleDO)this.seqRuleRepoProc.get(id);
        if (ruleDO == null) {
            return ApiResult.noData();
        }
        SeqRuleDetailsRespVO ruleRespVO = CONVERT.do2DetailRespVO(ruleDO);
        List<SysPlatformNumberRuleDtlDO> ruleDtlDoList = this.seqRuleDtlRepoProc.queryByRuleId(id);
        List<SeqRuleDetailRecordRespVO> ruleDtlVoList = ruleDtlDoList.stream().map(t -> {
            SeqRuleDetailRecordRespVO vo = CONVERT.do2RespVO((SysPlatformNumberRuleDtlDO)t);
            vo.setNumberTypeName(this.convertNumberTypeName(t.getNumberType()));
            return vo;
        }).collect(Collectors.toList());
        ruleRespVO.setDetailsList(ruleDtlVoList);
        return ApiResult.ok((Object)ruleRespVO);
    }

    @Override
    public ApiResult<PagingVO<SeqRulePageRespVO>> pageMng(SeqRulePageQueryVO queryVO) {
        PagingVO pageData = this.seqRuleRepoProc.pageMng(queryVO).map(CONVERT::do2MngRespVO);
        return ApiResult.ok((Object)pageData);
    }

    @Override
    public ApiResult<String> getSample(Long id, List<String> runtimeValues) {
        String sampleCode = this.seqNumFactory.generateSampleCode(id, runtimeValues);
        return ApiResult.ok((Object)sampleCode);
    }

    private String convertNumberTypeName(String numberType) {
        SysNumType type = SysNumType.parse((String)numberType);
        return type == null ? null : type.getDescription();
    }
}

