/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.model.entity;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.constant.Gender;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import java.time.LocalDateTime;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import org.springframework.util.StringUtils;

@Entity
@Table(name="sys_employee", indexes={@Index(name="idx_sys_emp_user_id", columnList="userId"), @Index(name="idx_sys_emp_root_org_id", columnList="rootOrgId"), @Index(name="idx_sys_emp_code", columnList="code"), @Index(name="idx_sys_emp_type", columnList="type"), @Index(name="idx_sys_emp_email", columnList="email")})
@Comment(value="\u5458\u5de5")
public class SysEmployeeDO
extends BaseModel {
    private static final long serialVersionUID = 3344534498352255891L;
    @Column(nullable=false)
    @Comment(value="\u7528\u6237\u8d26\u53f7ID")
    private Long userId;
    @Column(nullable=false)
    @Comment(value="\u6839\u7ec4\u7ec7ID")
    private Long rootOrgId;
    @Comment(value="\u7528\u6237\u8d26\u53f7")
    @Column
    private String username;
    @Comment(value="\u59d3\u540d-\u59d3\u6c0f")
    @Column
    private String lastName;
    @Comment(value="\u59d3\u540d-\u540d\u5b57")
    @Column
    private String firstName;
    @Column
    @Comment(value="\u6027\u522b\uff0c\uff08male-\u7537\uff0cfemale-\u5973\uff0csecret-\u4fdd\u5bc6\uff09")
    private String gender;
    @Column
    @Comment(value="\u5458\u5de5\u7f16\u53f7")
    private String code;
    @Column
    @Comment(value="\u5458\u5de5\u7c7b\u578b\uff0c[UDC]cloudt-system:employeeType")
    private String type;
    @Column
    @Comment(value="\u804c\u52a1")
    private String duty;
    @Column
    @Comment(value="\u5458\u5de5\u7167\u7247")
    private String photo;
    @Column
    @Comment(value="\u5408\u540c\u8d77\u59cb\u65f6\u95f4")
    private LocalDateTime contractStartTime;
    @Column
    @Comment(value="\u5408\u540c\u622a\u6b62\u65f6\u95f4")
    private LocalDateTime contractEndTime;
    @Column
    @Comment(value="\u5165\u804c\u65f6\u95f4")
    private LocalDateTime joinTime;
    @Comment(value="\u529e\u516c\u7535\u8bdd")
    @Column
    private String phone;
    @Comment(value="\u5de5\u4f5c\u90ae\u7bb1")
    @Column
    private String email;
    @Column
    @Comment(value="\u79bb\u804c\u65f6\u95f4")
    private LocalDateTime leaveTime;
    @Column
    @Comment(value="\u662f\u5426\u5728\u804c", defaultValue="1")
    private Boolean served;
    @Column
    @Comment(value="\u662f\u5426\u542f\u7528", defaultValue="1")
    private Boolean enabled;
    @Column
    @Comment(value="\u987a\u5e8f", defaultValue="1")
    private Integer sortNo;

    public String getFullName() {
        if (!StringUtils.hasText((String)this.lastName)) {
            return this.firstName;
        }
        return this.lastName + CharSequenceUtil.blankToDefault((CharSequence)this.firstName, (String)"");
    }

    public String getGenderName() {
        if (CharSequenceUtil.isBlank((CharSequence)this.getGender())) {
            return null;
        }
        return new Gender(this.getGender()).getDescription();
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SysEmployeeDO) {
            SysEmployeeDO the = (SysEmployeeDO)((Object)obj);
            if (this.getId() == null) {
                return the.getId() == null;
            }
            return this.getId().equals(the.getId());
        }
        return false;
    }

    public Long getUserId() {
        return this.userId;
    }

    public Long getRootOrgId() {
        return this.rootOrgId;
    }

    public String getUsername() {
        return this.username;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getGender() {
        return this.gender;
    }

    public String getCode() {
        return this.code;
    }

    public String getType() {
        return this.type;
    }

    public String getDuty() {
        return this.duty;
    }

    public String getPhoto() {
        return this.photo;
    }

    public LocalDateTime getContractStartTime() {
        return this.contractStartTime;
    }

    public LocalDateTime getContractEndTime() {
        return this.contractEndTime;
    }

    public LocalDateTime getJoinTime() {
        return this.joinTime;
    }

    public String getPhone() {
        return this.phone;
    }

    public String getEmail() {
        return this.email;
    }

    public LocalDateTime getLeaveTime() {
        return this.leaveTime;
    }

    public Boolean getServed() {
        return this.served;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public Integer getSortNo() {
        return this.sortNo;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public void setRootOrgId(Long rootOrgId) {
        this.rootOrgId = rootOrgId;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setDuty(String duty) {
        this.duty = duty;
    }

    public void setPhoto(String photo) {
        this.photo = photo;
    }

    public void setContractStartTime(LocalDateTime contractStartTime) {
        this.contractStartTime = contractStartTime;
    }

    public void setContractEndTime(LocalDateTime contractEndTime) {
        this.contractEndTime = contractEndTime;
    }

    public void setJoinTime(LocalDateTime joinTime) {
        this.joinTime = joinTime;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setLeaveTime(LocalDateTime leaveTime) {
        this.leaveTime = leaveTime;
    }

    public void setServed(Boolean served) {
        this.served = served;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public void setSortNo(Integer sortNo) {
        this.sortNo = sortNo;
    }
}

