/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.service.model.entity.QSysTenantDO;
import com.elitescloud.cloudt.system.service.model.entity.QSysTenantUserDO;
import com.elitescloud.cloudt.system.service.model.entity.SysTenantDO;
import com.elitescloud.cloudt.system.service.model.entity.SysTenantUserDO;
import com.elitescloud.cloudt.system.service.model.vo.SysUserTenantVO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository
public class SysTenantUserRepoProc
extends BaseRepoProc<SysTenantUserDO> {
    private static final QSysTenantUserDO QDO = QSysTenantUserDO.sysTenantUserDO;
    private static final QSysTenantDO QDO_TENANT = QSysTenantDO.sysTenantDO;

    public SysTenantUserRepoProc() {
        super((EntityPathBase)QDO);
    }

    public void deleteByTenant(long tenantId) {
        super.deleteByValue(SysTenantUserRepoProc.QDO.sysTenantId, (Object)tenantId);
    }

    public void unbindTenant(long tenantId, long userId) {
        this.jpaQueryFactory.delete((EntityPath)QDO).where(new Predicate[]{SysTenantUserRepoProc.QDO.sysUserId.eq((Object)userId).and((Predicate)SysTenantUserRepoProc.QDO.sysTenantId.eq((Object)tenantId))}).execute();
    }

    public void updateEnabled(Long tenantId, Long userId, Boolean enabled) {
        this.jpaQueryFactory.update((EntityPath)QDO).set((Path)SysTenantUserRepoProc.QDO.enabled, (Object)enabled).where(new Predicate[]{SysTenantUserRepoProc.QDO.sysUserId.eq((Object)userId).and((Predicate)SysTenantUserRepoProc.QDO.sysTenantId.eq((Object)tenantId))}).execute();
    }

    public SysTenantUserDO get(Long tenantId, Long userId) {
        return (SysTenantUserDO)((Object)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)QDO).from((EntityPath)QDO)).where((Predicate)SysTenantUserRepoProc.QDO.sysUserId.eq((Object)userId).and((Predicate)SysTenantUserRepoProc.QDO.sysTenantId.eq((Object)tenantId)))).limit(1L)).fetchOne());
    }

    public List<Long> getTenantIdOfUser(Long userId) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(SysTenantUserRepoProc.QDO.sysTenantId).from((EntityPath)QDO)).where((Predicate)SysTenantUserRepoProc.QDO.sysUserId.eq((Object)userId))).fetch();
    }

    public List<SysTenantDO> queryUserTenantDetail(Long userId) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)QDO_TENANT).from((EntityPath)QDO)).leftJoin((EntityPath)QDO_TENANT)).on((Predicate)SysTenantUserRepoProc.QDO_TENANT.id.eq(SysTenantUserRepoProc.QDO.sysTenantId))).where((Predicate)SysTenantUserRepoProc.QDO.sysUserId.eq((Object)userId).and((Predicate)SysTenantUserRepoProc.QDO_TENANT.deleteFlag.eq((Object)0)).and((Predicate)SysTenantUserRepoProc.QDO.enabled.eq(Boolean.valueOf(true))))).orderBy(SysTenantUserRepoProc.QDO.lastLoginTime.desc())).fetch();
    }

    public List<SysUserTenantVO> queryUserTenant(Long userId) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SysUserTenantVO.class, (Expression[])new Expression[]{SysTenantUserRepoProc.QDO.sysUserId, SysTenantUserRepoProc.QDO.sysTenantId, SysTenantUserRepoProc.QDO.bindTime, SysTenantUserRepoProc.QDO_TENANT.tenantCode, SysTenantUserRepoProc.QDO_TENANT.tenantName, SysTenantUserRepoProc.QDO_TENANT.tenantDomain, SysTenantUserRepoProc.QDO_TENANT.customDomain})).from((EntityPath)QDO)).leftJoin((EntityPath)QDO_TENANT)).on((Predicate)SysTenantUserRepoProc.QDO_TENANT.id.eq(SysTenantUserRepoProc.QDO.sysTenantId))).where((Predicate)SysTenantUserRepoProc.QDO.sysUserId.eq((Object)userId).and((Predicate)SysTenantUserRepoProc.QDO_TENANT.enabled.eq(Boolean.valueOf(true))))).fetch();
    }
}

