package com.elitescloud.cloudt.system.service.model.entity;

import com.elitescloud.boot.common.annotation.businessobject.OperationScopeEnum;
import com.elitescloud.boot.common.annotation.businessobject.OperationStateEnum;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;

import javax.persistence.*;

/**
 * 业务对象的操作.
 *
 * @author Kaiser（wang shao）
 * @date 2024/3/6
 */
@Entity
@Table(name = "sys_business_operation", indexes = {
        @Index(name = "idx_business_objopera_openapi", columnList = "openApiCode"),
        @Index(name = "idx_business_objopera_busiobj", columnList = "businessObjectId"),
        @Index(name = "idx_business_objopera_app", columnList = "appCode"),
        @Index(name = "idx_business_objopera_busiobjc", columnList = "businessObjectCode"),
        @Index(name = "idx_business_objopera_key", columnList = "operationCode", unique = true),
        @Index(name = "idx_business_objopera_type", columnList = "operationType"),
        @Index(name = "idx_business_objopera_perms", columnList = "permissionEnabled"),
        @Index(name = "idx_business_objopera_ref", columnList = "permissionRef"),
})
@Comment("业务对象的操作")
@DynamicInsert
@Getter
@Setter
public class SysBusinessOperationDO extends BaseModel {
    private static final long serialVersionUID = 498268279845138073L;
    // 查询的类型
    public static final String[] TYPES_SELECT = new String[]{
            OperationTypeEnum.SELECT_PAGE.name(), OperationTypeEnum.SELECT.name(), OperationTypeEnum.EXPORT.name()
    };

    @Comment(value = "OpenApi的编码")
    @Column()
    private String openApiCode;

    @Comment(value = "业务对象编码")
    @Column()
    private String businessObjectCode;

    @Comment(value = "业务对象ID")
    @Column(nullable = false)
    private Long businessObjectId;

    @Comment(value = "应用编码")
    @Column()
    private String appCode;

    @Comment(value = "操作编码")
    @Column(nullable = false)
    private String operationCode;

    @Comment(value = "操作名称")
    @Column()
    private String operationDescription;

    @Comment(value = "自定义名称")
    @Column()
    private String customName;

    @Comment(value = "详细描述")
    @Column()
    private String detail;

    @Comment(value = "关联权限的业务操作编码")
    @Column()
    private String permissionRef;

    /**
     * 取值：{@link com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum}
     */
    @Comment(value = "操作类型")
    @Column()
    private String operationType;

    @Comment(value = "是否启用权限", defaultValue = "0")
    @Column()
    private Boolean permissionEnabled;

    @Comment(value = "是否自动过滤字段权限", defaultValue = "0")
    @Column()
    private Boolean fieldPermissionAutoFilter;

    /**
     * 取值：{@link OperationScopeEnum}
     */
    @Comment(value = "操作范围")
    @Column()
    private String scope;

    /**
     * 取值：{@link OperationStateEnum}
     */
    @Comment(value = "操作状态")
    @Column()
    private String state;

    @Comment(value = "显示类型")
    @Column()
    private String displayType;

    @Comment(value = "显示样式")
    @Column()
    private String displayStyle;

    @Comment(value = "显示条件")
    @Column()
    private String displayCondition;

    @Comment(value = "显示图标")
    @Column()
    private String displayIcon;

    @Comment(value = "显示顺序")
    @Column()
    private Integer displayOrder;

    @Comment(value = "API操作名称")
    @Column()
    private String apiName;

    @Comment(value = "API描述")
    @Column()
    private String apiDescription;

    @Comment(value = "API的URL")
    @Column()
    private String apiUrl;

    @Comment(value = "API的方法")
    @Column()
    private String apiMethod;

    /**
     * 取值：{@link com.elitescloud.cloudt.system.service.common.constant.BusinessObjectSourceEnum}
     */
    @Comment(value = "数据来源")
    @Column()
    private String dataSource;

    @Comment(value = "是否启用", defaultValue = "1")
    @Column()
    private Boolean enabled;
}
