package com.elitescloud.cloudt.system.service.param;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author roman.zhang
 * @since 2022-03-25 15:17:52
 */
@Data
@ApiModel(description = "系统水印配置")
public class SysWatermarkConfigQueryParam extends AbstractOrderQueryParam {
    private static final long serialVersionUID = -32967120557118878L;
    /**
    * 记录唯一ID
    */    
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
    * 动态文字
    */    
    @ApiModelProperty("动态文字：前端将数据进行传递，并负责制定规则，比如通过|进行数据分割")
    private List<String> dynamicField;
    /**
    * 自定义文字
    */    
    @ApiModelProperty("自定义文字")
    private String customField;
    /**
    * 文字大小
    */    
    @ApiModelProperty("文字大小")
    private Integer fontSize;
    /**
    * 颜色深浅
    */    
    @ApiModelProperty("颜色深浅")
    private String fontColor;
    /**
    * 旋转角度
    */    
    @ApiModelProperty("旋转角度")
    private Integer rotate;
    /**
    * 层叠深度
    */    
    @ApiModelProperty("层叠深度")
    private Integer stackingDeep;
    /**
    * 租户ID
    */    
    @ApiModelProperty("租户ID")
    private Long tenantId;
    /**
    * 备注
    */    
    @ApiModelProperty("备注")
    private String remark;
    /**
    * 记录创建者ID
    */    
    @ApiModelProperty("记录创建者ID")
    private Long createUserId;
    /**
    * 记录创建者
    */    
    @ApiModelProperty("记录创建者")
    private String creator;
    /**
    * 记录创建时间
    */    
    @ApiModelProperty("记录创建时间")
    private String createTime;
    /**
    * 记录最后更新者ID
    */    
    @ApiModelProperty("记录最后更新者ID")
    private Long modifyUserId;
    /**
    * 记录最后更新者
    */    
    @ApiModelProperty("记录最后更新者")
    private String updater;
    /**
    * 记录最后更新时间
    */    
    @ApiModelProperty("记录最后更新时间")
    private String modifyTime;
    /**
    * 逻辑删除，0：未删除，1：已删除
    */    
    @ApiModelProperty("逻辑删除，0：未删除，1：已删除")
    private Integer deleteFlag;
    /**
    * 锁版本
    */    
    @ApiModelProperty("锁版本")
    private Integer auditDataVersion;
    /**
    * sec_bu_id
    */    
    @ApiModelProperty("sec_bu_id")
    private Long secBuId;
    /**
    * sec_user_id
    */    
    @ApiModelProperty("sec_user_id")
    private Long secUserId;
    /**
    * sec_ou_id
    */    
    @ApiModelProperty("sec_ou_id")
    private Long secOuId;


}
