package com.elitescloud.cloudt.system.service;

import com.elitescloud.cloudt.system.dto.SysUserBasicDTO;
import com.elitescloud.cloudt.system.dto.req.UserCreateDTO;

import java.util.Map;
import java.util.Set;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/10/27
 */
public interface IUserService {

    /**
     * 用户创建
     *
     * @param createDTO 用户信息
     * @return 用户ID
     */
    Long insertUser(UserCreateDTO createDTO);

    /**
     * 增加用户类型
     *
     * @param id        用户ID
     * @param userTypes 用户类型
     * @return 用户ID
     */
    Long addUserType(Long id, Set<String> userTypes);

    /**
     * 删掉用户类型
     *
     * @param id        用户ID
     * @param userTypes 用户类型
     * @return 用户ID
     */
    Long removeUserType(Long id, Set<String> userTypes);

    /**
     * 增加用户终端
     *
     * @param id        用户ID
     * @param terminals 终端
     * @return 用户ID
     */
    Long addUserTerminal(Long id, Set<String> terminals);

    /**
     * 增加用户终端
     *
     * @param id        用户ID
     * @param terminals 终端
     * @return 用户ID
     */
    Long removeUserTerminal(Long id, Set<String> terminals);

    /**
     * 更新CAS同步结果
     *
     * @param userMap 用户信息
     * @return 更新结果
     */
    boolean updateCasSyncResult(Map<String, Long> userMap);

    /**
     * 判断账号是否存在
     *
     * @param username 账号
     * @param id       排除的用户ID
     * @return 是否存在
     */
    boolean existsUsername(String username, Long id);

    /**
     * 判断手机号是否存在
     *
     * @param mobile 手机号
     * @param id     排除的用户ID
     * @return 是否存在
     */
    boolean existsMobile(String mobile, Long id);

    /**
     * 判断手机号是否存在
     *
     * @param email 手机号
     * @param id    排除的用户ID
     * @return 是否存在
     */
    boolean existsEmail(String email, Long id);

    /**
     * 根据账号获取唯一的用户ID
     *
     * @param username 登录账号
     * @return 用户ID
     */
    Long getUniqueIdByUsername(String username);

    /**
     * 根据手机号获取唯一的用户ID
     *
     * @param mobile 手机号
     * @return 用户ID
     */
    Long getUniqueIdByMobile(String mobile);

    /**
     * 根据邮箱获取唯一的用户ID
     *
     * @param email 邮箱
     * @return 用户ID
     */
    Long getUniqueIdByEmail(String email);

    /**
     * 根据ID查询信息
     *
     * @param id 用户ID
     * @return 用户信息
     */
    SysUserBasicDTO getById(Long id);
}
