package com.elitescloud.cloudt.system.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.service.param.SysWatermarkConfigCreateParam;
import com.elitescloud.cloudt.system.service.param.SysWatermarkConfigQueryParam;
import com.elitescloud.cloudt.system.service.param.SysWatermarkConfigUpdateParam;
import com.elitescloud.cloudt.system.service.vo.SysWatermarkConfigVO;

import java.util.List;
import java.util.Optional;
/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author roman.zhang
 * @since 2022-03-25 15:17:52
 */
public interface SysWatermarkConfigService {
 /**
     * 检索 
     * @param queryParam 分类查询、分页和排序对象
     * @return 分页结果集
     */
    PagingVO<SysWatermarkConfigVO> search(SysWatermarkConfigQueryParam queryParam);

    /**
     * 根据关键字段，返回对应的vo
     * @param Code  code
     * @return  对象
     */
    Optional<SysWatermarkConfigVO> findCodeOne(String Code);

    /**
     * 返回数据，返回一条数据
     * @return
     */
    Optional<SysWatermarkConfigVO> findOne();
    /**
     * 根据关键字段，返回对应的
     * @param Id ID
     * @return 对象
     */
    Optional<SysWatermarkConfigVO> findIdOne(Long Id);
    /**
     * 根据关键字段，返回对应的
     * @param idList ID集合
     * @return 对象
     */
   List<SysWatermarkConfigVO>  findIdBatch(List<Long> idList);
    /**
     * 创建
     *
     * @param  creatParam 对象
     */
    Long createOne(SysWatermarkConfigCreateParam creatParam);
    /**
     * 创建
     *
     * @param List 对象集合
     */
    List<Long> createBatch(List<SysWatermarkConfigCreateParam> List);
    /**
     * 更新
     *
     * @param  updateParam 对象
     */
    void update(SysWatermarkConfigUpdateParam updateParam) ;

    /**
     * 删除
     *
     * @param Id 对象
     */
    void deleteOne(Long Id);
    /**
     * 删除
     *
     * @param idList 对象集合
     */
    void deleteBatch(List<Long> idList);

    /**
     * 更新删除标识
     *
     * @param id id
     */
    void updateDeleteFlag(Long id);
}


