package com.elitescloud.cloudt.system.service.callback;

import javax.validation.constraints.NotBlank;

/**
 * APP改变后的回调.
 *
 * @author Kaiser（wang shao）
 * @date 2023/4/24
 */
public interface AppChangedCallback {

    /**
     * 保存应用
     *
     * @param add     是否是新增操作
     * @param appCode 应用编码
     */
    default void onSave(boolean add, @NotBlank String appCode) {};

    /**
     * 修改应用启用状态
     *
     * @param appCode 应用编码
     * @param enable  启用状态
     */
    default void onEnabled(@NotBlank String appCode, boolean enable) {};

    /**
     * 删除APP
     *
     * @param appCode 应用编码
     * @param real    是否真删除
     */
    default void onDelete(@NotBlank String appCode, boolean real) {};
}
