package com.elitescloud.cloudt.system.service.model.bo;

import com.elitescloud.boot.datasecurity.dpr.content.DprRuleConditionEnum;
import com.elitescloud.boot.datasecurity.dpr.content.DprRuleValueTypeEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 数据权限-行规则.
 *
 * @author Kaiser（wang shao）
 * @date 3/29/2023
 */
@Data
public class SysDprApiCustomRuleSaveBO {
    /**
     * 规则名称
     */
    private String dprRuleName;

    /**
     * 规则字段
     */
    private String dprRuleField;

    /**
     * 规则条件
     */
    private DprRuleConditionEnum dprRuleCondition;

    /**
     * 取值方式
     */
    @NotNull
    private DprRuleValueTypeEnum dprRuleValueType;

    /**
     * 数据集类型
     */
    private String dataSet;

    /**
     * 规则值
     */
    @NotBlank
    private String dprRuleValue;

    /**
     * 规则值名称
     */
    private String dprRuleValueName;

    /**
     * 规则描述
     */
    private String dprRuleDeclare;

    /**
     * 特用字段1
     */
    private String bs1;

    /**
     * 特用字段1
     */
    private String bs2;

    /**
     * 特用字段1
     */
    private String bs3;
}
