package com.elitescloud.cloudt.system.service.model.bo;

import com.elitescloud.boot.core.support.customfield.common.CustomFieldAbstractVo;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 员工保存信息.
 *
 * @author Kaiser（wang shao）
 * 2022/10/9
 */
@Data
public class SysEmployeeSaveBO extends CustomFieldAbstractVo {

    /**
     * 员工ID
     */
    private Long id;

    /**
     * 所在组织ID
     */
    private List<SysEmployeeOrgSaveBO> orgInfoList;

    /**
     * 用户账号ID
     */
    private Long userId;

    /**
     * 是否没有登录账号
     */
    private Boolean withoutLoginAccount;

    /**
     * 用户账号信息
     */
    private SysUserSaveBO userSaveBO;

    /**
     * 员工编号
     */
    private String code;

    /**
     * 职务
     */
    private String duty;

    /**
     * 工作邮箱
     */
    private String emailWork;

    /**
     * 办公电话
     */
    private String phone;

    /**
     * 入职时间
     */
    private LocalDateTime joinTime;

    /**
     * 离职时间
     */
    private LocalDateTime leaveTime;

    /**
     * 员工类型，[UDC]EMPLOYEE:TYPE
     */
    private String type;

    /**
     * 员工照片
     */
    private String photo;

    /**
     * 合同起始时间
     */
    private LocalDateTime contractStartTime;

    /**
     * 合同截止时间
     */
    private LocalDateTime contractEndTime;

    /**
     * 是否启用
     */
    private Boolean enabled;

    /**
     * 是否在职
     */
    private Boolean served;

    /**
     * 顺序
     */
    private Integer sortNo;

    /**
     * 员工身份
     */
    private List<SysUserTypeBO> identityList;
}
