package com.elitescloud.cloudt.system.service.model.bo;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Map;

/**
 * 同步信息保存.
 *
 * @author Kaiser（wang shao）
 * @date 2024/8/26
 */
@Getter
@Setter
public class SysSyncSaveBO implements Serializable {
    private static final long serialVersionUID = -1973493528208933458L;

    /**
     * 数据类型
     * <p>
     * {@link com.elitescloud.cloudt.system.service.common.constant.SyncDataType}
     */
    private String dataType;

    /**
     * 数据的唯一标识
     */
    private String dataKey;

    /**
     * 是否是向外同步
     */
    private Boolean syncOuter;

    /**
     * 外部系统标识
     */
    private String outerApp;

    /**
     * 外部数据的唯一标识
     */
    private String outerDataKey;

    /**
     * 同步时间
     */
    private LocalDateTime syncDataTime;

    /**
     * 是否手工同步
     */
    private Boolean manual;

    /**
     * 是否同步成功
     */
    private Boolean syncSuccess;

    /**
     * 同步失败原因
     */
    private String failReason;

    /**
     * 扩展信息
     */
    private Map<String, Object> attr;
}
