package com.elitescloud.cloudt.system.service.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 业务对象.
 *
 * @author Kaiser（wang shao）
 * @date 2024/3/5
 */
@Entity
@Table(name = "sys_business_object", indexes = {
        @Index(name = "idx_business_obj_openapi", columnList = "openApiCode"),
        @Index(name = "idx_business_obj_app", columnList = "appCode"),
        @Index(name = "idx_business_obj_code", columnList = "code", unique = true),
        @Index(name = "idx_business_obj_domain", columnList = "domain"),
})
@Comment("业务对象")
@DynamicInsert
@Getter
@Setter
public class SysBusinessObjectDO extends BaseModel {
    private static final long serialVersionUID = 2879763608765956025L;

    @Comment(value = "OpenApi的编码")
    @Column()
    private String openApiCode;

    @Comment(value = "应用编码")
    @Column()
    private String appCode;

    @Comment(value = "业务对象的编码")
    @Column()
    private String code;

    @Comment(value = "业务对象的名称")
    @Column()
    private String name;

    @Comment(value = "自定义名称")
    @Column()
    private String customName;

    @Comment(value = "业务对象的描述")
    @Column()
    private String description;

    @Comment(value = "entity类的名称")
    @Column()
    private String entityClassName;

    @Comment(value = "领域分类")
    @Column()
    private String domain;

    @Comment(value = "是否启用", defaultValue = "1")
    @Column()
    private Boolean enabled;

    @Comment(value = "是否是公共资源", defaultValue = "0")
    @Column()
    private Boolean publicResource;

    @Comment(value = "是否支持租户", defaultValue = "1")
    @Column()
    private Boolean supportTenant;

    /**
     * 取值：{@link com.elitescloud.cloudt.system.service.common.constant.BusinessObjectSourceEnum}
     */
    @Comment(value = "数据来源")
    @Column()
    private String dataSource;
}
