package com.elitescloud.cloudt.system.service.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 业务对象的关联关系.
 *
 * @author Kaiser（wang shao）
 * @date 2024/4/3
 */
@Entity
@Table(name = "sys_business_object_ref", indexes = {
        @Index(name = "idx_business_obj_ref_openapi", columnList = "openApiCode"),
        @Index(name = "idx_business_obj_ref_objid", columnList = "businessObjectId"),
        @Index(name = "idx_business_obj_ref_objc", columnList = "businessObjectCode"),
        @Index(name = "idx_business_obj_ref_ref", columnList = "ref")
})
@Comment("业务对象的关联关系")
@DynamicInsert
@Getter
@Setter
public class SysBusinessObjectRefDO extends BaseModel {
    private static final long serialVersionUID = 2763445819251581796L;

    @Comment(value = "OpenApi的编码")
    @Column()
    private String openApiCode;

    @Comment(value = "业务对象ID")
    @Column(nullable = false)
    private Long businessObjectId;

    @Comment(value = "业务对象编码")
    @Column(nullable = false)
    private String businessObjectCode;

    @Comment(value = "关联标识")
    @Column(nullable = false)
    private String ref;

    /**
     * 取值：{@link com.elitescloud.cloudt.system.service.common.constant.BusinessObjectRefTypeEnum}
     */
    @Comment(value = "关联类型")
    @Column(nullable = false)
    private String refType;

    @Comment(value = "顺序", defaultValue = "0")
    @Column()
    private Integer sortNo;

    /**
     * 取值：{@link com.elitescloud.cloudt.system.service.common.constant.BusinessObjectSourceEnum}
     */
    @Comment(value = "数据来源")
    @Column()
    private String dataSource;
}
